/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.redis.services;

import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.redis.services.RedisContainer;
import org.apache.camel.test.infra.redis.services.RedisService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisLocalContainerService
implements RedisService,
ContainerService<RedisContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(RedisLocalContainerService.class);
    private final RedisContainer container;

    public RedisLocalContainerService() {
        this.container = new RedisContainer();
    }

    public RedisLocalContainerService(String imageName) {
        this.container = RedisContainer.initContainer(imageName, "redis");
    }

    public void registerProperties() {
        System.setProperty("redis.service.address", this.getServiceAddress());
        System.setProperty("redis.port", String.valueOf(this.port()));
        System.setProperty("redis.host", this.host());
    }

    public void initialize() {
        LOG.info("Trying to start the Redis container");
        this.container.start();
        this.registerProperties();
        LOG.info("Redis instance running at {}", (Object)this.getServiceAddress());
    }

    public void shutdown() {
        LOG.info("Stopping the Redis container");
        this.container.stop();
    }

    public RedisContainer getContainer() {
        return this.container;
    }

    @Override
    public String host() {
        return this.container.getHost();
    }

    @Override
    public int port() {
        return this.container.getMappedPort(6379);
    }
}

