/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.redis.services;

import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.redis.services.RedisService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class RedisLocalContainerService
implements RedisService,
ContainerService<GenericContainer> {
    public static final String CONTAINER_IMAGE = "redis:6.0.9";
    public static final String CONTAINER_NAME = "redis";
    private static final Logger LOG = LoggerFactory.getLogger(RedisLocalContainerService.class);
    private final GenericContainer container;

    public RedisLocalContainerService() {
        this(System.getProperty("redis.container", CONTAINER_IMAGE));
    }

    public RedisLocalContainerService(String imageName) {
        this.container = this.initContainer(imageName, CONTAINER_NAME);
    }

    public RedisLocalContainerService(GenericContainer container) {
        this.container = container;
    }

    public GenericContainer initContainer(String imageName, String networkAlias) {
        return new GenericContainer(DockerImageName.parse((String)imageName)).withNetworkAliases(new String[]{networkAlias}).withExposedPorts(new Integer[]{6379}).waitingFor((WaitStrategy)Wait.forListeningPort());
    }

    public void registerProperties() {
        System.setProperty("redis.service.address", this.getServiceAddress());
        System.setProperty("redis.port", String.valueOf(this.port()));
        System.setProperty("redis.host", this.host());
    }

    public void initialize() {
        LOG.info("Trying to start the Redis container");
        this.container.start();
        this.registerProperties();
        LOG.info("Redis instance running at {}", (Object)this.getServiceAddress());
    }

    public void shutdown() {
        LOG.info("Stopping the Redis container");
        this.container.stop();
    }

    public GenericContainer getContainer() {
        return this.container;
    }

    @Override
    public String host() {
        return this.container.getHost();
    }

    @Override
    public int port() {
        return this.container.getMappedPort(6379);
    }
}

