/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.rabbitmq.services;

import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.rabbitmq.services.ConnectionProperties;
import org.apache.camel.test.infra.rabbitmq.services.RabbitMQService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.RabbitMQContainer;

public class RabbitMQLocalContainerService
implements RabbitMQService,
ContainerService<RabbitMQContainer> {
    public static final String RABBITMQ_CONTAINER_IMAGE = "rabbitmq:3.8-management";
    private static final Logger LOG = LoggerFactory.getLogger(RabbitMQLocalContainerService.class);
    private final RabbitMQContainer container;

    public RabbitMQLocalContainerService() {
        this(System.getProperty("rabbitmq.container", RABBITMQ_CONTAINER_IMAGE));
    }

    public RabbitMQLocalContainerService(String imageName) {
        this.container = this.initContainer(imageName);
    }

    public RabbitMQLocalContainerService(RabbitMQContainer container) {
        this.container = container;
    }

    protected RabbitMQContainer initContainer(String imageName) {
        return new RabbitMQContainer(imageName);
    }

    public RabbitMQContainer getContainer() {
        return this.container;
    }

    @Override
    public ConnectionProperties connectionProperties() {
        return new ConnectionProperties(){

            @Override
            public String username() {
                return RabbitMQLocalContainerService.this.container.getAdminUsername();
            }

            @Override
            public String password() {
                return RabbitMQLocalContainerService.this.container.getAdminPassword();
            }

            @Override
            public String hostname() {
                return RabbitMQLocalContainerService.this.container.getHost();
            }

            @Override
            public int port() {
                return RabbitMQLocalContainerService.this.container.getAmqpPort();
            }
        };
    }

    @Override
    public String getAmqpUrl() {
        return this.container.getAmqpUrl();
    }

    @Override
    public int getHttpPort() {
        return this.container.getHttpPort();
    }

    public void registerProperties() {
        ConnectionProperties properties = this.connectionProperties();
        System.setProperty("rabbitmq.user.name", properties.username());
        System.setProperty("rabbitmq.user.password", properties.password());
        System.setProperty("rabbitmq.connection.hostname", properties.hostname());
        System.setProperty("rabbitmq.connection.amqp", String.valueOf(properties.port()));
    }

    @Override
    public void initialize() {
        LOG.info("Trying to start RabbitMQ container");
        this.container.start();
        LOG.info("RabbitMQ container running on {}", (Object)this.container.getAmqpUrl());
        this.registerProperties();
    }

    @Override
    public void shutdown() {
        this.container.stop();
    }
}

