/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.pulsar.services;

import org.apache.camel.test.infra.common.services.SimpleTestServiceBuilder;
import org.apache.camel.test.infra.common.services.SingletonService;
import org.apache.camel.test.infra.common.services.TestService;
import org.apache.camel.test.infra.pulsar.services.PulsarLocalContainerService;
import org.apache.camel.test.infra.pulsar.services.PulsarRemoteService;
import org.apache.camel.test.infra.pulsar.services.PulsarService;

public final class PulsarServiceFactory {
    private PulsarServiceFactory() {
    }

    public static SimpleTestServiceBuilder<PulsarService> builder() {
        return new SimpleTestServiceBuilder("pulsar");
    }

    public static PulsarService createService() {
        return (PulsarService)PulsarServiceFactory.builder().addLocalMapping(PulsarLocalContainerService::new).addRemoteMapping(PulsarRemoteService::new).build();
    }

    public static PulsarService createSingletonService() {
        return (PulsarService)PulsarServiceFactory.builder().addLocalMapping(() -> new SingletonPulsarService(new PulsarLocalContainerService(), "pulsar")).build();
    }

    public static class SingletonPulsarService
    extends SingletonService<PulsarService>
    implements PulsarService {
        public SingletonPulsarService(PulsarService service, String name) {
            super((TestService)service, name);
        }

        @Override
        public String getPulsarAdminUrl() {
            return ((PulsarService)this.getService()).getPulsarAdminUrl();
        }

        @Override
        public String getPulsarBrokerUrl() {
            return ((PulsarService)this.getService()).getPulsarBrokerUrl();
        }
    }
}

