/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.opensearch.services;

import org.apache.camel.test.infra.common.services.SimpleTestServiceBuilder;
import org.apache.camel.test.infra.common.services.SingletonService;
import org.apache.camel.test.infra.common.services.TestService;
import org.apache.camel.test.infra.opensearch.services.OpenSearchLocalContainerService;
import org.apache.camel.test.infra.opensearch.services.OpenSearchService;
import org.apache.camel.test.infra.opensearch.services.RemoteOpenSearchService;

public final class OpenSearchServiceFactory {
    private OpenSearchServiceFactory() {
    }

    public static SimpleTestServiceBuilder<OpenSearchService> builder() {
        return new SimpleTestServiceBuilder("opensearch");
    }

    public static OpenSearchService createService() {
        return (OpenSearchService)OpenSearchServiceFactory.builder().addLocalMapping(OpenSearchLocalContainerService::new).addRemoteMapping(RemoteOpenSearchService::new).build();
    }

    public static OpenSearchService createSingletonService() {
        return SingletonServiceHolder.INSTANCE;
    }

    private static class SingletonServiceHolder {
        static final OpenSearchService INSTANCE;

        private SingletonServiceHolder() {
        }

        static {
            SimpleTestServiceBuilder<OpenSearchService> instance = OpenSearchServiceFactory.builder();
            instance.addLocalMapping(() -> new SingletonOpenSearchService(new OpenSearchLocalContainerService(), "opensearch")).addRemoteMapping(RemoteOpenSearchService::new);
            INSTANCE = (OpenSearchService)instance.build();
        }
    }

    static class SingletonOpenSearchService
    extends SingletonService<OpenSearchService>
    implements OpenSearchService {
        public SingletonOpenSearchService(OpenSearchService service, String name) {
            super((TestService)service, name);
        }

        @Override
        public int getPort() {
            return ((OpenSearchService)this.getService()).getPort();
        }

        @Override
        public String getOpenSearchHost() {
            return ((OpenSearchService)this.getService()).getOpenSearchHost();
        }

        @Override
        public String getHttpHostAddress() {
            return ((OpenSearchService)this.getService()).getHttpHostAddress();
        }

        @Override
        public String getUsername() {
            return ((OpenSearchService)this.getService()).getUsername();
        }

        @Override
        public String getPassword() {
            return ((OpenSearchService)this.getService()).getPassword();
        }
    }
}

