/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.openldap.services;

import org.apache.camel.test.infra.common.LocalPropertyResolver;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.openldap.services.OpenldapService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.FixedHostPortGenericContainer;
import org.testcontainers.containers.GenericContainer;

public class OpenldapLocalContainerService
implements OpenldapService,
ContainerService<GenericContainer> {
    public static final String OPENLDAP_CONTAINER_PROPERTY = "openldap.container";
    public static final String CONTAINER_NAME = "openldap";
    public static final int CONTAINER_PORT_LDAP = 389;
    public static final int CONTAINER_PORT_LDAP_OVER_SSL = 636;
    private static final Logger LOG = LoggerFactory.getLogger(OpenldapLocalContainerService.class);
    private final GenericContainer container;

    public OpenldapLocalContainerService() {
        this(LocalPropertyResolver.getProperty(OpenldapLocalContainerService.class, (String)OPENLDAP_CONTAINER_PROPERTY));
    }

    public OpenldapLocalContainerService(int port, int sslPort) {
        String imageName = System.getProperty(OPENLDAP_CONTAINER_PROPERTY, LocalPropertyResolver.getProperty(OpenldapLocalContainerService.class, (String)OPENLDAP_CONTAINER_PROPERTY));
        this.container = this.initContainer(imageName, port, sslPort);
    }

    public OpenldapLocalContainerService(String imageName) {
        this.container = this.initContainer(imageName, null, null);
    }

    public OpenldapLocalContainerService(GenericContainer container) {
        this.container = container;
    }

    protected GenericContainer initContainer(String imageName, Integer port, Integer sslPort) {
        FixedHostPortGenericContainer ret;
        if (port == null) {
            ret = new GenericContainer(imageName).withExposedPorts(new Integer[]{389, 636});
        } else {
            FixedHostPortGenericContainer fixedPortContainer = new FixedHostPortGenericContainer(imageName).withFixedExposedPort(port.intValue(), 389);
            if (sslPort != null) {
                fixedPortContainer.withFixedExposedPort(sslPort.intValue(), 636);
            }
            ret = fixedPortContainer;
        }
        ret.withNetworkAliases(new String[]{CONTAINER_NAME});
        return ret;
    }

    public void registerProperties() {
        System.setProperty("openldap.port.ldap", String.valueOf(this.getPort()));
        System.setProperty("openldap.port.ldap.ssl", String.valueOf(this.getSslPort()));
    }

    public void initialize() {
        LOG.info("Trying to start the Openldap container");
        this.container.start();
        this.registerProperties();
        LOG.info("Openldap instance running at {}", (Object)this.getPort());
    }

    public void shutdown() {
        LOG.info("Stopping the Openldap container");
        this.container.stop();
    }

    public GenericContainer getContainer() {
        return this.container;
    }

    @Override
    public Integer getPort() {
        return this.container.getMappedPort(389);
    }

    @Override
    public Integer getSslPort() {
        return this.container.getMappedPort(636);
    }

    @Override
    public String getHost() {
        return this.container.getHost();
    }
}

