/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.openai.mock;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.StreamSupport;
import org.apache.camel.test.infra.openai.mock.ToolCallDefinition;

public class ResponseBuilder {
    private final ObjectMapper objectMapper;

    public ResponseBuilder(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public String createSimpleTextResponse(String content) throws Exception {
        Map<String, Object> responseMessage = this.createBaseMessage();
        responseMessage.put("content", content);
        Map<String, Object> choice = this.createBaseChoice("stop", responseMessage);
        Map<String, Object> chatCompletion = this.createBaseChatCompletion(choice);
        return this.objectMapper.writeValueAsString(chatCompletion);
    }

    public String createToolCallResponse(String content, List<ToolCallDefinition> toolCalls) throws Exception {
        Map<String, Object> responseMessage = this.createBaseMessage();
        responseMessage.put("content", content);
        responseMessage.put("tool_calls", this.buildToolCallsList(toolCalls));
        Map<String, Object> choice = this.createBaseChoice("tool_calls", responseMessage);
        Map<String, Object> chatCompletion = this.createBaseChatCompletion(choice);
        return this.objectMapper.writeValueAsString(chatCompletion);
    }

    public String createFinalToolResponse(JsonNode messagesNode, String fallbackContent, String toolContentResponse) throws Exception {
        Object content;
        Map<String, Object> responseMessage = this.createBaseMessage();
        if (fallbackContent != null) {
            content = fallbackContent;
        } else if (toolContentResponse != null) {
            String toolContent = this.extractLastToolContent(messagesNode).orElse("");
            content = toolContent + " " + toolContentResponse;
        } else {
            content = this.extractLastToolContent(messagesNode).orElse("All tools processed");
        }
        responseMessage.put("content", content);
        Map<String, Object> choice = this.createBaseChoice("stop", responseMessage);
        Map<String, Object> chatCompletion = this.createBaseChatCompletion(choice);
        chatCompletion.put("history", messagesNode);
        return this.objectMapper.writeValueAsString(chatCompletion);
    }

    public String createFinalToolResponse(JsonNode messagesNode, String fallbackContent) throws Exception {
        return this.createFinalToolResponse(messagesNode, fallbackContent, null);
    }

    public String createErrorResponse(int statusCode, String errorMessage, HttpExchange exchange) {
        String jsonErrorMessage = String.format("{\"error\": \"%s\"}", errorMessage);
        try {
            exchange.sendResponseHeaders(statusCode, jsonErrorMessage.length());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return String.format("{\"error\": \"%s\"}", errorMessage);
    }

    private Map<String, Object> createBaseMessage() {
        HashMap<String, Object> message = new HashMap<String, Object>();
        message.put("role", "assistant");
        message.put("refusal", null);
        return message;
    }

    private Map<String, Object> createBaseChoice(String finishReason, Map<String, Object> message) {
        HashMap<String, Object> choice = new HashMap<String, Object>();
        choice.put("finish_reason", finishReason);
        choice.put("index", 0);
        choice.put("message", message);
        return choice;
    }

    private Map<String, Object> createBaseChatCompletion(Map<String, Object> choice) {
        HashMap<String, Object> chatCompletion = new HashMap<String, Object>();
        chatCompletion.put("id", UUID.randomUUID().toString());
        chatCompletion.put("choices", Collections.singletonList(choice));
        chatCompletion.put("created", System.currentTimeMillis() / 1000L);
        chatCompletion.put("model", "openai-mock");
        chatCompletion.put("object", "chat.completion");
        return chatCompletion;
    }

    private List<Map<String, Object>> buildToolCallsList(List<ToolCallDefinition> toolCalls) throws Exception {
        ArrayList<Map<String, Object>> toolCallsList = new ArrayList<Map<String, Object>>();
        for (ToolCallDefinition toolCall : toolCalls) {
            String argumentsJson = this.objectMapper.writeValueAsString(toolCall.getArguments());
            HashMap<String, String> functionObject = new HashMap<String, String>();
            functionObject.put("name", toolCall.getName());
            functionObject.put("arguments", argumentsJson);
            HashMap<String, Object> toolCallItem = new HashMap<String, Object>();
            toolCallItem.put("id", UUID.randomUUID().toString());
            toolCallItem.put("type", "function");
            toolCallItem.put("function", functionObject);
            toolCallsList.add(toolCallItem);
        }
        return toolCallsList;
    }

    private Optional<String> extractLastToolContent(JsonNode messagesNode) {
        return StreamSupport.stream(messagesNode.spliterator(), false).filter(entry -> entry.has("role") && "tool".equals(entry.get("role").asText())).reduce((first, second) -> second).map(entry -> entry.get("content")).map(JsonNode::asText);
    }
}

