/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.openai.mock;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.camel.test.infra.openai.mock.MockExpectation;
import org.apache.camel.test.infra.openai.mock.MockResponseType;
import org.apache.camel.test.infra.openai.mock.RequestContext;
import org.apache.camel.test.infra.openai.mock.ResponseBuilder;
import org.apache.camel.test.infra.openai.mock.ToolExecutionStep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RequestHandler.class);
    private final List<MockExpectation> expectations;
    private final ResponseBuilder responseBuilder;
    private final ObjectMapper objectMapper;

    public RequestHandler(List<MockExpectation> expectations, ObjectMapper objectMapper) {
        this.expectations = expectations;
        this.objectMapper = objectMapper;
        this.responseBuilder = new ResponseBuilder(objectMapper);
    }

    public String handleRequest(HttpExchange exchange) throws IOException {
        try {
            String requestBody = new String(exchange.getRequestBody().readAllBytes(), StandardCharsets.UTF_8);
            LOG.debug("Processing request: {}", (Object)requestBody);
            JsonNode rootNode = this.objectMapper.readTree(requestBody);
            RequestContext context = new RequestContext(rootNode);
            MockExpectation expectation = this.findExpectationByInput(context.getLastUserMessage());
            if (context.hasToolRole() && !expectation.getToolSequence().isEmpty()) {
                return this.handleToolSequenceResponse(context, exchange);
            }
            return this.handleUserInput(requestBody, context, exchange);
        }
        catch (Exception e) {
            String errorMessage = "Error processing request: " + e.getMessage();
            LOG.error(errorMessage);
            return this.responseBuilder.createErrorResponse(500, errorMessage, exchange);
        }
    }

    private String handleToolSequenceResponse(RequestContext context, HttpExchange exchange) throws Exception {
        String originalInput = context.getLastUserMessage();
        if (originalInput == null) {
            LOG.warn("Could not find original user input in message history");
            return this.responseBuilder.createErrorResponse(400, "Original user input not found", exchange);
        }
        MockExpectation expectation = this.findExpectationByInput(originalInput);
        if (expectation == null) {
            LOG.warn("No matching expectation found for tool sequence with input: {}", (Object)originalInput);
            return this.responseBuilder.createErrorResponse(404, "No matching expectation found for tool sequence", exchange);
        }
        expectation.advanceToNextToolStep();
        if (expectation.hasMoreToolSteps()) {
            LOG.debug("Executing next tool step for expectation: {}", (Object)originalInput);
            String result = this.createToolCallResponse(expectation);
            return result;
        }
        LOG.debug("Tool sequence completed for expectation: {}", (Object)originalInput);
        return this.responseBuilder.createFinalToolResponse(context.getMessagesNode(), expectation.getExpectedResponse(), expectation.getToolContentResponse());
    }

    private String handleUserInput(String requestBody, RequestContext context, HttpExchange exchange) throws Exception {
        String userInput = context.getLastUserMessage();
        if (userInput == null) {
            LOG.warn("User message content not found in request");
            throw new IllegalArgumentException("User message content not found in request");
        }
        MockExpectation expectation = this.findExpectationByInput(userInput);
        expectation.resetToolSequence();
        if (expectation.getRequestAssertion() != null) {
            expectation.getRequestAssertion().accept(requestBody);
        }
        return this.createResponse(expectation, userInput, exchange);
    }

    private String createResponse(MockExpectation expectation, String userInput, HttpExchange exchange) throws Exception {
        MockResponseType responseType = expectation.getResponseType();
        switch (responseType) {
            case CUSTOM_FUNCTION: {
                LOG.debug("Using custom response function");
                return expectation.getCustomResponseFunction().apply(exchange, userInput);
            }
            case TOOL_CALLS: {
                return this.createToolCallResponse(expectation);
            }
        }
        LOG.debug("Creating simple text response");
        return this.responseBuilder.createSimpleTextResponse(expectation.getExpectedResponse());
    }

    private String createToolCallResponse(MockExpectation expectation) throws Exception {
        ToolExecutionStep currentStep = expectation.getCurrentToolStep();
        return this.responseBuilder.createToolCallResponse(expectation.getExpectedResponse(), currentStep.getToolCalls());
    }

    private MockExpectation findExpectationByInput(String input) {
        return this.expectations.stream().filter(expectation -> expectation.matches(input)).findFirst().orElseThrow(() -> new IllegalStateException(String.format("No matching mock expectation found for input: %s", input)));
    }
}

