/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.openai.mock;

import com.fasterxml.jackson.databind.JsonNode;

public class RequestContext {
    private final JsonNode rootNode;
    private final JsonNode messagesNode;

    public RequestContext(JsonNode rootNode) {
        this.rootNode = rootNode;
        this.messagesNode = rootNode.path("messages");
    }

    public boolean hasToolRole() {
        if (!this.messagesNode.isArray() || this.messagesNode.size() == 0) {
            return false;
        }
        JsonNode lastMessage = this.messagesNode.get(this.messagesNode.size() - 1);
        String role = lastMessage.path("role").asText();
        return "tool".equals(role);
    }

    public String getLastUserMessage() {
        if (!this.messagesNode.isArray()) {
            return null;
        }
        for (int i = this.messagesNode.size(); i > 0; --i) {
            JsonNode messageNode = this.messagesNode.get(i - 1);
            String role = messageNode.path("role").asText();
            if (!"user".equals(role)) continue;
            return messageNode.path("content").asText();
        }
        return null;
    }

    public JsonNode getMessagesNode() {
        return this.messagesNode;
    }

    public JsonNode getRootNode() {
        return this.rootNode;
    }
}

