/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.openai.mock;

import com.sun.net.httpserver.HttpExchange;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.apache.camel.test.infra.openai.mock.MockResponseType;
import org.apache.camel.test.infra.openai.mock.ToolExecutionSequence;
import org.apache.camel.test.infra.openai.mock.ToolExecutionStep;

public class MockExpectation {
    private final String expectedInput;
    private final ToolExecutionSequence toolSequence;
    private String expectedResponse;
    private String toolContentResponse;
    private BiFunction<HttpExchange, String, String> customResponseFunction;
    private Consumer<String> requestAssertion;

    public MockExpectation(String expectedInput) {
        this.expectedInput = expectedInput;
        this.toolSequence = new ToolExecutionSequence();
    }

    public String getExpectedInput() {
        return this.expectedInput;
    }

    public String getExpectedResponse() {
        return this.expectedResponse;
    }

    public String getToolContentResponse() {
        return this.toolContentResponse;
    }

    public BiFunction<HttpExchange, String, String> getCustomResponseFunction() {
        return this.customResponseFunction;
    }

    public Consumer<String> getRequestAssertion() {
        return this.requestAssertion;
    }

    public ToolExecutionSequence getToolSequence() {
        return this.toolSequence;
    }

    public void setExpectedResponse(String expectedResponse) {
        this.expectedResponse = expectedResponse;
    }

    public void setCustomResponseFunction(BiFunction<HttpExchange, String, String> customResponseFunction) {
        this.customResponseFunction = customResponseFunction;
    }

    public void setRequestAssertion(Consumer<String> requestAssertion) {
        this.requestAssertion = requestAssertion;
    }

    public void setToolContentResponse(String toolContentResponse) {
        this.toolContentResponse = toolContentResponse;
    }

    public void addToolExecutionStep(ToolExecutionStep step) {
        this.toolSequence.addStep(step);
    }

    public ToolExecutionStep getCurrentToolStep() {
        return this.toolSequence.getCurrentStep();
    }

    public void advanceToNextToolStep() {
        this.toolSequence.advanceToNextStep();
    }

    public boolean hasMoreToolSteps() {
        return this.toolSequence.hasMoreSteps();
    }

    public boolean isInToolSequence() {
        return this.toolSequence.isInProgress();
    }

    public void resetToolSequence() {
        this.toolSequence.reset();
    }

    public MockResponseType getResponseType() {
        if (this.customResponseFunction != null) {
            return MockResponseType.CUSTOM_FUNCTION;
        }
        if (!this.toolSequence.isEmpty() && this.toolSequence.hasCurrentStep()) {
            return MockResponseType.TOOL_CALLS;
        }
        return MockResponseType.SIMPLE_TEXT;
    }

    public boolean matches(String input) {
        return this.expectedInput.equals(input);
    }

    public String toString() {
        return String.format("MockExpectation{input='%s', response='%s', toolSteps=%d}", this.expectedInput, this.expectedResponse, this.toolSequence.getTotalSteps());
    }
}

