/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.ollama.services;

import com.github.dockerjava.api.DockerClient;
import java.util.List;
import org.apache.camel.test.infra.common.LocalPropertyResolver;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.ollama.services.OllamaContainer;
import org.apache.camel.test.infra.ollama.services.OllamaService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.utility.DockerImageName;

public class OllamaLocalContainerService
implements OllamaService,
ContainerService<OllamaContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(OllamaLocalContainerService.class);
    public static final String CONTAINER_PORT = LocalPropertyResolver.getProperty(OllamaLocalContainerService.class, (String)"ollama.port");
    public static final String CONTAINER_NAME = LocalPropertyResolver.getProperty(OllamaLocalContainerService.class, (String)"ollama.container");
    public static String OLLAMA_MODEL = LocalPropertyResolver.getProperty(OllamaLocalContainerService.class, (String)"ollama.model");
    public static final String LOCAL_OLLAMA_IMAGE = String.format("tc-%s-%s", CONTAINER_NAME, OLLAMA_MODEL);
    private final DockerImageName dockerImageName;
    private final OllamaContainer container;
    private final Integer port = Integer.valueOf(CONTAINER_PORT);

    public OllamaLocalContainerService() {
        this.dockerImageName = this.resolveImageName();
        this.container = this.initContainer();
    }

    protected OllamaContainer initContainer() {
        return new OllamaContainer(this.dockerImageName, this.port, OLLAMA_MODEL, LOCAL_OLLAMA_IMAGE);
    }

    protected DockerImageName resolveImageName() {
        DockerImageName dockerImageName = DockerImageName.parse((String)CONTAINER_NAME);
        DockerClient dockerClient = DockerClientFactory.instance().client();
        List images = (List)dockerClient.listImagesCmd().withReferenceFilter(LOCAL_OLLAMA_IMAGE).exec();
        if (images.isEmpty()) {
            return dockerImageName;
        }
        return DockerImageName.parse((String)LOCAL_OLLAMA_IMAGE);
    }

    @Override
    public String getBaseUrl() {
        return "http://" + this.container.getHost() + ":" + this.container.getMappedPort(this.port);
    }

    @Override
    public String getModel() {
        return OLLAMA_MODEL;
    }

    public void registerProperties() {
        System.setProperty("ollama.port", String.valueOf(this.port));
        System.setProperty("ollama.url", String.valueOf(this.getBaseUrl()));
    }

    public void initialize() {
        LOG.info("Trying to start the Ollama container");
        this.container.start();
        this.registerProperties();
        LOG.info("Ollama instance running at {}", (Object)this.port);
    }

    public void shutdown() {
        LOG.info("Stopping the Ollama container");
        this.container.stop();
    }

    public OllamaContainer getContainer() {
        return this.container;
    }
}

