/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.ollama.services;

import com.github.dockerjava.api.command.InspectContainerResponse;
import java.io.IOException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class OllamaContainer
extends GenericContainer<OllamaContainer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OllamaContainer.class);
    private final DockerImageName dockerImageName;
    private final Integer port;
    private final String model;
    private final String imageName;

    public OllamaContainer(DockerImageName image, Integer port, String model, String imageName) {
        super(image);
        this.dockerImageName = image;
        this.port = port;
        this.model = model;
        this.imageName = imageName;
        ((OllamaContainer)((OllamaContainer)((OllamaContainer)this.withExposedPorts(new Integer[]{port})).withImagePullPolicy(dockerImageName -> !dockerImageName.getVersionPart().endsWith(model))).withLogConsumer((Consumer)new Slf4jLogConsumer(LOGGER))).setWaitStrategy((WaitStrategy)Wait.forListeningPort());
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo) {
        if (!this.dockerImageName.equals((Object)DockerImageName.parse((String)this.imageName))) {
            try {
                LOGGER.info("Start pulling the '{}' model ... would take several minutes ...", (Object)this.model);
                this.execInContainer(new String[]{"ollama", "pull", this.model});
                LOGGER.info("Model pulling competed!");
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException("Error pulling model", e);
            }
        }
    }
}

