/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.ollama.services;

import java.io.IOException;
import org.apache.camel.spi.annotations.InfraService;
import org.apache.camel.test.infra.common.LocalPropertyResolver;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.ollama.services.OllamaInfraService;
import org.apache.camel.test.infra.ollama.services.OllamaServiceConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.ollama.OllamaContainer;
import org.testcontainers.utility.DockerImageName;

@InfraService(service=OllamaInfraService.class, description="Build and run LLMs with Ollama", serviceAlias={"ollama"})
public class OllamaLocalContainerInfraService
implements OllamaInfraService,
ContainerService<OllamaContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(OllamaLocalContainerInfraService.class);
    public static final String CONTAINER_NAME = LocalPropertyResolver.getProperty(OllamaLocalContainerInfraService.class, (String)"ollama.container");
    private final OllamaContainer container;
    private final OllamaServiceConfiguration configuration;

    public OllamaLocalContainerInfraService() {
        this.container = this.initContainer();
        this.configuration = new DefaultServiceConfiguration();
    }

    public OllamaLocalContainerInfraService(OllamaServiceConfiguration serviceConfiguration) {
        this.configuration = serviceConfiguration;
        this.container = this.initContainer();
    }

    protected OllamaContainer initContainer() {
        return new OllamaContainer(DockerImageName.parse((String)CONTAINER_NAME).asCompatibleSubstituteFor("ollama/ollama"));
    }

    @Override
    public String getEndpoint() {
        return this.container.getEndpoint();
    }

    @Override
    public String getModel() {
        return this.configuration.modelName();
    }

    public void registerProperties() {
        System.setProperty("ollama.endpoint", this.container.getEndpoint());
    }

    public void initialize() {
        LOG.info("Trying to start the Ollama container");
        this.container.start();
        LOG.info("Pulling the model {}", (Object)this.getModel());
        try {
            this.container.execInContainer(new String[]{"ollama", "pull", this.getModel()});
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.registerProperties();
        LOG.info("Ollama instance running at {}", (Object)this.getEndpoint());
    }

    public void shutdown() {
        LOG.info("Stopping the Ollama container");
        this.container.stop();
    }

    public OllamaContainer getContainer() {
        return this.container;
    }

    private static class DefaultServiceConfiguration
    implements OllamaServiceConfiguration {
        private DefaultServiceConfiguration() {
        }

        @Override
        public String modelName() {
            return LocalPropertyResolver.getProperty(OllamaLocalContainerInfraService.class, (String)"ollama.model");
        }
    }
}

