/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.nats.services;

import org.apache.camel.test.infra.common.LocalPropertyResolver;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.nats.services.NatsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class NatsLocalContainerService
implements NatsService,
ContainerService<GenericContainer> {
    public static final String CONTAINER_NAME = "nats";
    private static final int PORT = 4222;
    private static final Logger LOG = LoggerFactory.getLogger(NatsLocalContainerService.class);
    private final GenericContainer container;

    public NatsLocalContainerService() {
        this(LocalPropertyResolver.getProperty(NatsLocalContainerService.class, (String)"nats.container"));
    }

    public NatsLocalContainerService(String imageName) {
        this.container = this.initContainer(imageName, CONTAINER_NAME);
    }

    protected GenericContainer initContainer(String imageName, String containerName) {
        return new GenericContainer(imageName).withNetworkAliases(new String[]{containerName}).withExposedPorts(new Integer[]{4222}).waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Listening.*for.*route.*connections.*", (int)1));
    }

    public void registerProperties() {
        System.setProperty("nat.service.address", this.getServiceAddress());
    }

    public void initialize() {
        LOG.info("Trying to start the Nats container");
        this.container.start();
        this.registerProperties();
        LOG.info("Nats instance running at {}", (Object)this.getServiceAddress());
    }

    public void shutdown() {
        LOG.info("Stopping the Nats container");
        this.container.stop();
    }

    public GenericContainer getContainer() {
        return this.container;
    }

    protected String getHost() {
        return this.container.getHost();
    }

    protected int getPort() {
        return this.container.getMappedPort(4222);
    }

    @Override
    public String getServiceAddress() {
        return String.format("%s:%d", this.getHost(), this.getPort());
    }
}

