/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.mosquitto.services;

import org.apache.camel.test.infra.common.LocalPropertyResolver;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.mosquitto.services.MosquittoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.FixedHostPortGenericContainer;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class MosquittoLocalContainerService
implements MosquittoService,
ContainerService<GenericContainer> {
    public static final String CONTAINER_NAME = "mosquitto";
    public static final int CONTAINER_PORT = 1883;
    private static final Logger LOG = LoggerFactory.getLogger(MosquittoLocalContainerService.class);
    private final GenericContainer container;

    public MosquittoLocalContainerService() {
        this(LocalPropertyResolver.getProperty(MosquittoLocalContainerService.class, (String)"mosquitto.container"));
    }

    public MosquittoLocalContainerService(int port) {
        String imageName = LocalPropertyResolver.getProperty(MosquittoLocalContainerService.class, (String)"mosquitto.container");
        this.container = this.initContainer(imageName, port);
    }

    public MosquittoLocalContainerService(String imageName) {
        this.container = this.initContainer(imageName, null);
    }

    public MosquittoLocalContainerService(GenericContainer container) {
        this.container = container;
    }

    protected GenericContainer initContainer(String imageName, Integer port) {
        FixedHostPortGenericContainer fixedPortContainer;
        Object ret = port == null ? new GenericContainer(imageName).withExposedPorts(new Integer[]{1883}) : (fixedPortContainer = new FixedHostPortGenericContainer(imageName).withFixedExposedPort(port.intValue(), 1883));
        ret.withNetworkAliases(new String[]{CONTAINER_NAME}).withClasspathResourceMapping("mosquitto.conf", "/mosquitto/config/mosquitto.conf", BindMode.READ_ONLY).waitingFor((WaitStrategy)Wait.forLogMessage((String)".* mosquitto version .* running", (int)1)).waitingFor((WaitStrategy)Wait.forListeningPort());
        return ret;
    }

    public void registerProperties() {
        System.setProperty("mosquitto.port", String.valueOf(this.getPort()));
    }

    public void initialize() {
        LOG.info("Trying to start the Mosquitto container");
        this.container.start();
        this.registerProperties();
        LOG.info("Mosquitto instance running at {}", (Object)this.getPort());
    }

    public void shutdown() {
        LOG.info("Stopping the Mosquitto container");
        this.container.stop();
    }

    public GenericContainer getContainer() {
        return this.container;
    }

    @Override
    public Integer getPort() {
        return this.container.getMappedPort(1883);
    }
}

