/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.milvus.services;

import org.apache.camel.test.infra.common.services.SimpleTestServiceBuilder;
import org.apache.camel.test.infra.common.services.SingletonService;
import org.apache.camel.test.infra.common.services.TestService;
import org.apache.camel.test.infra.milvus.services.MilvusLocalContainerService;
import org.apache.camel.test.infra.milvus.services.MilvusRemoteService;
import org.apache.camel.test.infra.milvus.services.MilvusService;

public final class MilvusServiceFactory {
    private MilvusServiceFactory() {
    }

    public static SimpleTestServiceBuilder<MilvusService> builder() {
        return new SimpleTestServiceBuilder("milvus");
    }

    public static MilvusService createService() {
        return (MilvusService)MilvusServiceFactory.builder().addLocalMapping(MilvusLocalContainerService::new).addRemoteMapping(MilvusRemoteService::new).build();
    }

    public static MilvusService createSingletonService() {
        return (MilvusService)MilvusServiceFactory.builder().addLocalMapping(() -> new SingletonMilvusService(new MilvusLocalContainerService(), "milvus")).build();
    }

    public static class SingletonMilvusService
    extends SingletonService<MilvusService>
    implements MilvusService {
        public SingletonMilvusService(MilvusService service, String name) {
            super((TestService)service, name);
        }

        @Override
        public String getMilvusEndpointUrl() {
            return ((MilvusService)this.getService()).getMilvusEndpointUrl();
        }

        @Override
        public String getMilvusHost() {
            return ((MilvusService)this.getService()).getMilvusHost();
        }

        @Override
        public int getMilvusPort() {
            return ((MilvusService)this.getService()).getMilvusPort();
        }
    }
}

