/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.microprofile.lra.services;

import com.github.dockerjava.api.model.Network;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.microprofile.lra.services.MicroprofileLRAService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class MicroprofileLRALocalContainerService
implements MicroprofileLRAService,
ContainerService<GenericContainer> {
    public static final String CONTAINER_IMAGE = "quay.io/jbosstm/lra-coordinator:5.13.0.Final-2.12.3.Final";
    public static final String CONTAINER_NAME = "microprofile-lra";
    private static final Logger LOG = LoggerFactory.getLogger(MicroprofileLRALocalContainerService.class);
    private final GenericContainer container;

    public MicroprofileLRALocalContainerService() {
        this(System.getProperty("microprofile.lra.container", CONTAINER_IMAGE));
    }

    public MicroprofileLRALocalContainerService(String imageName) {
        this.container = this.initContainer(imageName, CONTAINER_NAME);
    }

    public MicroprofileLRALocalContainerService(GenericContainer container) {
        this.container = container;
    }

    public GenericContainer initContainer(String imageName, String networkAlias) {
        return new GenericContainer(DockerImageName.parse((String)imageName)).withNetworkAliases(new String[]{networkAlias}).withExposedPorts(new Integer[]{8080}).waitingFor((WaitStrategy)Wait.forListeningPort()).waitingFor((WaitStrategy)Wait.forLogMessage((String)".*lra-coordinator-quarkus.*Listening on.*", (int)1));
    }

    public void registerProperties() {
        System.setProperty("microprofile.lra.service.address", this.getServiceAddress());
        System.setProperty("microprofile.lra.port", String.valueOf(this.port()));
        System.setProperty("microprofile.lra.host", this.host());
    }

    public void initialize() {
        LOG.info("Trying to start the Microprofile LRA container");
        this.container.start();
        this.registerProperties();
        LOG.info("Microprofile LRA instance running at {}", (Object)this.getServiceAddress());
    }

    public void shutdown() {
        LOG.info("Stopping the Microprofile LRA container");
        this.container.stop();
    }

    public GenericContainer getContainer() {
        return this.container;
    }

    @Override
    public String host() {
        return this.container.getHost();
    }

    @Override
    public int port() {
        return this.container.getMappedPort(8080);
    }

    @Override
    public String callbackHost() {
        Network bridgeNetwork = this.container.getDockerClient().inspectNetworkCmd().withNetworkId("bridge").exec();
        String networkGateway = bridgeNetwork.getIpam().getConfig().stream().filter(config -> config.getGateway() != null).findAny().map(Network.Ipam.Config::getGateway).orElseThrow(() -> new IllegalStateException("Gateway cannot be found in the bridge network"));
        return networkGateway;
    }
}

