/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.kafka.services;

import com.github.dockerjava.api.command.CreateContainerCmd;
import org.apache.camel.test.infra.kafka.services.StrimziContainer;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class ZookeeperContainer
extends GenericContainer<ZookeeperContainer> {
    private static final String ZOOKEEPER_CONTAINER = StrimziContainer.STRIMZI_CONTAINER;
    private static final int ZOOKEEPER_PORT = 2181;

    public ZookeeperContainer(Network network, String name) {
        this(network, name, ZOOKEEPER_CONTAINER);
    }

    public ZookeeperContainer(Network network, String name, String containerName) {
        super(containerName);
        ((ZookeeperContainer)((ZookeeperContainer)((ZookeeperContainer)((ZookeeperContainer)((ZookeeperContainer)this.withEnv("LOG_DIR", "/tmp/logs")).withExposedPorts(new Integer[]{2181})).withNetwork(network)).withCreateContainerCmdModifier(createContainerCmd -> this.setupContainer(name, (CreateContainerCmd)createContainerCmd))).withCommand(new String[]{"sh", "-c", "bin/zookeeper-server-start.sh config/zookeeper.properties"})).waitingFor((WaitStrategy)Wait.forListeningPort());
    }

    private void setupContainer(String name, CreateContainerCmd createContainerCmd) {
        createContainerCmd.withHostName(name);
        createContainerCmd.withName(name);
    }

    public int getZookeeperPort() {
        return this.getMappedPort(2181);
    }
}

