/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.kafka.services;

import org.apache.camel.test.infra.common.TestUtils;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.kafka.services.KafkaService;
import org.apache.camel.test.infra.kafka.services.StrimziContainer;
import org.apache.camel.test.infra.kafka.services.ZookeeperContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Network;

public class StrimziService
implements KafkaService,
ContainerService<StrimziContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(StrimziService.class);
    private final ZookeeperContainer zookeeperContainer;
    private final StrimziContainer strimziContainer;

    public StrimziService() {
        this("zookeeper-" + TestUtils.randomWithRange((int)1, (int)100), "strimzi-" + TestUtils.randomWithRange((int)1, (int)100));
    }

    public StrimziService(String zookeeperInstanceName, String strimziInstanceName) {
        Network network = Network.newNetwork();
        this.zookeeperContainer = this.initZookeeperContainer(network, zookeeperInstanceName);
        this.strimziContainer = this.initStrimziContainer(network, strimziInstanceName, zookeeperInstanceName);
    }

    public StrimziService(ZookeeperContainer zookeeperContainer, StrimziContainer strimziContainer) {
        this.zookeeperContainer = zookeeperContainer;
        this.strimziContainer = strimziContainer;
    }

    protected StrimziContainer initStrimziContainer(Network network, String instanceName, String zookeeperInstanceName) {
        return new StrimziContainer(network, instanceName, zookeeperInstanceName);
    }

    protected ZookeeperContainer initZookeeperContainer(Network network, String instanceName) {
        return new ZookeeperContainer(network, instanceName);
    }

    protected Integer getKafkaPort() {
        return this.strimziContainer.getKafkaPort();
    }

    @Override
    public String getBootstrapServers() {
        return this.strimziContainer.getHost() + ":" + this.getKafkaPort();
    }

    public void registerProperties() {
        System.setProperty("kafka.bootstrap.servers", this.getBootstrapServers());
    }

    public void initialize() {
        this.zookeeperContainer.start();
        String zookeeperConnect = this.zookeeperContainer.getHost() + ":" + this.zookeeperContainer.getZookeeperPort();
        LOG.info("Apache Zookeeper running at address {}", (Object)zookeeperConnect);
        this.strimziContainer.start();
        this.registerProperties();
        LOG.info("Kafka bootstrap server running at address {}", (Object)this.getBootstrapServers());
    }

    private boolean stopped() {
        return !this.strimziContainer.isRunning() && !this.zookeeperContainer.isRunning();
    }

    public void shutdown() {
        try {
            LOG.info("Stopping Kafka container");
            this.strimziContainer.stop();
        }
        finally {
            LOG.info("Stopping Zookeeper container");
            this.zookeeperContainer.stop();
            TestUtils.waitFor(this::stopped);
        }
    }

    public StrimziContainer getContainer() {
        return this.strimziContainer;
    }

    protected ZookeeperContainer getZookeeperContainer() {
        return this.zookeeperContainer;
    }
}

