/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.jetty.services;

import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.camel.test.infra.jetty.services.JettyConfiguration;
import org.apache.camel.test.infra.jetty.services.JettyService;
import org.awaitility.Awaitility;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class JettyEmbeddedService
implements JettyService,
BeforeEachCallback,
AfterEachCallback {
    private final JettyConfiguration jettyConfiguration;
    private ServerConnector connector;
    private Server server;

    public JettyEmbeddedService(JettyConfiguration jettyConfiguration) {
        this.jettyConfiguration = jettyConfiguration;
    }

    private ServerConnector createConnector(JettyConfiguration jettyConfiguration) {
        ServerConnector connector;
        SSLContext sslContext = jettyConfiguration.getSslContext();
        if (sslContext != null) {
            SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
            sslContextFactory.setSslContext(sslContext);
            connector = new ServerConnector(this.server, new ConnectionFactory[]{new SslConnectionFactory((SslContextFactory)sslContextFactory, null)});
        } else {
            connector = new ServerConnector(this.server);
        }
        return connector;
    }

    public void registerProperties() {
        System.setProperty("jetty.address", "localhost:" + this.getPort());
    }

    private void doInitialize() {
        try {
            this.server = new Server(this.jettyConfiguration.getPort());
            this.connector = this.createConnector(this.jettyConfiguration);
            this.server.addConnector((Connector)this.connector);
            Handler contextHandler = this.jettyConfiguration.getContextHandlerConfiguration().resolve();
            this.server.setHandler(contextHandler);
            this.server.start();
            Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> ((Server)this.server).isStarted());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void initialize() {
        if (this.server == null || this.server.isStopped()) {
            this.doInitialize();
        }
    }

    public void shutdown() {
        if (this.server != null && this.server.isStarted()) {
            this.doShutdown();
        }
    }

    private synchronized void doShutdown() {
        try {
            this.stop();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (this.server.isStopped()) {
                this.server.destroy();
            }
            this.server = null;
        }
    }

    public void stop() throws Exception {
        this.server.stop();
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> ((Server)this.server).isStopped());
    }

    public void afterEach(ExtensionContext extensionContext) {
        this.shutdown();
    }

    public void beforeEach(ExtensionContext extensionContext) {
        this.initialize();
    }

    @Override
    public int getPort() {
        return this.jettyConfiguration.getPort();
    }
}

