/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.ignite.services;

import java.util.Collections;
import java.util.UUID;
import org.apache.camel.test.infra.ignite.services.IgniteService;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.logger.log4j2.Log4J2Logger;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IgniteEmbeddedService
implements IgniteService {
    private static final Logger LOG = LoggerFactory.getLogger(IgniteEmbeddedService.class);
    private static final TcpDiscoveryIpFinder LOCAL_IP_FINDER = new TcpDiscoveryVmIpFinder(false){
        {
            this.setAddresses(Collections.singleton("127.0.0.1:47500..47509"));
        }
    };
    private Ignite ignite;

    public void registerProperties() {
    }

    public void initialize() {
    }

    public void shutdown() {
    }

    @Override
    public IgniteConfiguration createConfiguration() {
        System.setProperty("IGNITE_QUIET", "true");
        System.setProperty("IGNITE_PERFORMANCE_SUGGESTIONS_DISABLED", "true");
        System.setProperty("IGNITE_NO_ASCII", "true");
        System.setProperty("IGNITE_CONSOLE_APPENDER", "true");
        IgniteConfiguration config = new IgniteConfiguration();
        config.setIgniteInstanceName(UUID.randomUUID().toString());
        config.setIncludeEventTypes(new int[]{45, 41});
        config.setDiscoverySpi((DiscoverySpi)new TcpDiscoverySpi().setIpFinder(LOCAL_IP_FINDER));
        try {
            Log4J2Logger serviceLogger = new Log4J2Logger(this.getClass().getResource("log4j2.properties"));
            config.setGridLogger((IgniteLogger)serviceLogger);
        }
        catch (IgniteCheckedException e) {
            LOG.warn("Unable to configure Ignite log");
        }
        return config;
    }
}

