/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.hdfs.v2.services;

import org.apache.camel.test.AvailablePortFinder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.testcontainers.containers.GenericContainer;

public class HDFSContainer
extends GenericContainer {
    private MiniDFSCluster cluster;

    public void start() {
        try {
            Configuration conf = new Configuration();
            conf.set("dfs.namenode.fs-limits.max-directory-items", "1048576");
            this.cluster = new MiniDFSCluster.Builder(conf).nameNodePort(AvailablePortFinder.getNextAvailable()).numDataNodes(3).format(true).build();
        }
        catch (Throwable e) {
            this.logger().warn("Couldn't start HDFS cluster. Test is not started, but passed!", e);
        }
    }

    public void stop() {
        try {
            if (this.cluster != null) {
                this.cluster.shutdown();
            }
        }
        catch (Exception e) {
            this.logger().warn("Error shutting down the HDFS container", (Throwable)e);
        }
    }

    public String getHost() {
        return "localhost";
    }

    public int getPort() {
        return this.cluster.getNameNodePort();
    }
}

