/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.hbase.services;

import org.apache.camel.test.infra.common.services.SimpleTestServiceBuilder;
import org.apache.camel.test.infra.common.services.SingletonService;
import org.apache.camel.test.infra.common.services.TestService;
import org.apache.camel.test.infra.hbase.services.HBaseLocalContainerService;
import org.apache.camel.test.infra.hbase.services.HBaseService;
import org.apache.hadoop.conf.Configuration;
import org.junit.jupiter.api.extension.ExtensionContext;

public final class HBaseServiceFactory {
    private static SimpleTestServiceBuilder<HBaseService> instance;
    private static HBaseService service;

    private HBaseServiceFactory() {
    }

    public static SimpleTestServiceBuilder<HBaseService> builder() {
        return new SimpleTestServiceBuilder("hbase");
    }

    public static HBaseService createService() {
        return (HBaseService)HBaseServiceFactory.builder().addLocalMapping(HBaseLocalContainerService::new).build();
    }

    public static HBaseService createSingletonService() {
        if (service == null) {
            if (instance == null) {
                instance = HBaseServiceFactory.builder();
                instance.addLocalMapping(() -> new SingletonHBaseService(new HBaseLocalContainerService(), "hbase"));
            }
            service = (HBaseService)instance.build();
        }
        return service;
    }

    static class SingletonHBaseService
    extends SingletonService<HBaseService>
    implements HBaseService {
        public SingletonHBaseService(HBaseService service, String name) {
            super((TestService)service, name);
        }

        @Override
        public Configuration getConfiguration() {
            return ((HBaseService)this.getService()).getConfiguration();
        }

        @Override
        public void beforeAll(ExtensionContext extensionContext) {
            this.addToStore(extensionContext);
        }

        @Override
        public void afterAll(ExtensionContext extensionContext) {
        }
    }
}

