/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.google.pubsub.services;

import org.apache.camel.test.infra.common.LocalPropertyResolver;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.google.pubsub.services.GooglePubSubService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.PubSubEmulatorContainer;
import org.testcontainers.utility.DockerImageName;

public class GooglePubSubLocalContainerService
implements GooglePubSubService,
ContainerService<PubSubEmulatorContainer> {
    public static final String PROJECT_ID;
    private static final Logger LOG;
    private static final String DEFAULT_PROJECT_ID = "test-project";
    private final PubSubEmulatorContainer container;

    public GooglePubSubLocalContainerService() {
        this(LocalPropertyResolver.getProperty(GooglePubSubLocalContainerService.class, (String)"google.pubsub.container"));
    }

    public GooglePubSubLocalContainerService(String imageName) {
        this.container = this.initContainer(imageName);
    }

    public GooglePubSubLocalContainerService(PubSubEmulatorContainer container) {
        this.container = container;
    }

    protected PubSubEmulatorContainer initContainer(String imageName) {
        return new PubSubEmulatorContainer(DockerImageName.parse((String)imageName));
    }

    public void registerProperties() {
        System.setProperty("google.pubsub.service.address", this.getServiceAddress());
    }

    public void initialize() {
        LOG.info("Trying to start the GooglePubSub container");
        this.container.start();
        this.registerProperties();
        LOG.info("GooglePubSub instance running at {}", (Object)this.getServiceAddress());
    }

    public void shutdown() {
        LOG.info("Stopping the GooglePubSub container");
        this.container.stop();
    }

    public PubSubEmulatorContainer getContainer() {
        return this.container;
    }

    @Override
    public String getServiceAddress() {
        return String.format("%s:%d", this.container.getHost(), this.container.getFirstMappedPort());
    }

    static {
        LOG = LoggerFactory.getLogger(GooglePubSubLocalContainerService.class);
        PROJECT_ID = System.getProperty("google.pubsub.project.id", DEFAULT_PROJECT_ID);
    }
}

