/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.ftp.services.embedded;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.camel.test.infra.common.services.AbstractTestService;
import org.apache.camel.test.infra.ftp.services.FtpService;
import org.apache.camel.test.infra.ftp.services.embedded.EmbeddedConfiguration;
import org.apache.camel.test.infra.ftp.services.embedded.EmbeddedConfigurationBuilder;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.file.virtualfs.VirtualFileSystemFactory;
import org.apache.sshd.common.keyprovider.FileKeyPairProvider;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.session.helpers.AbstractSession;
import org.apache.sshd.common.signature.BuiltinSignatures;
import org.apache.sshd.scp.server.ScpCommandFactory;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.command.CommandFactory;
import org.apache.sshd.sftp.server.SftpSubsystemFactory;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SftpEmbeddedService
extends AbstractTestService
implements FtpService {
    private static final Logger LOG = LoggerFactory.getLogger(SftpEmbeddedService.class);
    protected SshServer sshd;
    protected final boolean rootDirMode;
    protected int port;
    private Path rootDir;
    private Path knownHosts;
    private final EmbeddedConfiguration embeddedConfiguration;
    private ExtensionContext context;

    public SftpEmbeddedService() {
        this(false);
    }

    public SftpEmbeddedService(boolean rootDirMode) {
        this(rootDirMode, EmbeddedConfigurationBuilder.defaultSftpConfiguration());
    }

    protected SftpEmbeddedService(boolean rootDirMode, EmbeddedConfiguration embeddedConfiguration) {
        this.rootDirMode = rootDirMode;
        this.embeddedConfiguration = embeddedConfiguration;
    }

    public void setUp() throws Exception {
        this.rootDir = this.testDirectory().resolve(this.embeddedConfiguration.getTestDirectory());
        this.knownHosts = this.testDirectory().resolve(this.embeddedConfiguration.getKnownHostsPath());
        Files.createDirectories(this.knownHosts.getParent(), new FileAttribute[0]);
        Files.write(this.knownHosts, this.buildKnownHosts(), new OpenOption[0]);
        this.setUpServer();
    }

    private Path testDirectory() {
        return Paths.get("target", "ftp", this.context.getRequiredTestClass().getSimpleName());
    }

    public void setUpServer() throws Exception {
        this.sshd = SshServer.setUpDefaultServer();
        this.sshd.setPort(this.port);
        this.sshd.setKeyPairProvider((KeyPairProvider)new FileKeyPairProvider(Paths.get(this.embeddedConfiguration.getKeyPairFile(), new String[0])));
        this.sshd.setSubsystemFactories(Collections.singletonList(new SftpSubsystemFactory()));
        this.sshd.setCommandFactory((CommandFactory)new ScpCommandFactory());
        this.sshd.setPasswordAuthenticator((username, password, session) -> true);
        this.sshd.setPublickeyAuthenticator(this.getPublickeyAuthenticator());
        if (this.rootDirMode) {
            File testDirectory = new File(this.embeddedConfiguration.getTestDirectory());
            this.sshd.setFileSystemFactory((FileSystemFactory)new VirtualFileSystemFactory(this.testDirectory().resolve(testDirectory.getParentFile().getName()).toAbsolutePath()));
        }
        List signatureFactories = this.sshd.getSignatureFactories();
        signatureFactories.clear();
        signatureFactories.add(BuiltinSignatures.rsaSHA512);
        signatureFactories.add(BuiltinSignatures.nistp521);
        signatureFactories.add(BuiltinSignatures.ed25519);
        this.sshd.setSignatureFactories(signatureFactories);
        this.sshd.start();
        this.port = ((InetSocketAddress)this.sshd.getBoundAddresses().iterator().next()).getPort();
    }

    protected PublickeyAuthenticator getPublickeyAuthenticator() {
        return (username, key, session) -> true;
    }

    public void tearDown() {
        this.tearDownServer();
    }

    public void tearDownServer() {
        try {
            if (this.sshd != null) {
                this.sshd.stop(true);
            }
        }
        catch (Exception e) {
            LOG.trace("Exception while shutting down: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            this.sshd = null;
        }
    }

    public void disconnectAllSessions() throws IOException {
        List sessions = this.sshd.getActiveSessions();
        for (AbstractSession session : sessions) {
            session.disconnect(4, "dummy");
        }
    }

    public byte[] buildKnownHosts() {
        return String.format(this.embeddedConfiguration.getKnownHosts(), this.port).getBytes();
    }

    public String getKnownHostsFile() {
        return this.knownHosts.toString();
    }

    @Override
    public Path getFtpRootDir() {
        return this.rootDir;
    }

    protected void registerProperties(BiConsumer<String, String> store) {
        store.accept("ftp.server.host", this.embeddedConfiguration.getServerAddress());
        store.accept("ftp.server.port", String.valueOf(this.port));
        store.accept("ftp.root.dir", this.rootDir.toString());
    }

    public void registerProperties() {
        ExtensionContext.Store store = this.context.getStore(ExtensionContext.Namespace.GLOBAL);
        this.registerProperties((arg_0, arg_1) -> ((ExtensionContext.Store)store).put(arg_0, arg_1));
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public void beforeAll(ExtensionContext extensionContext) {
        this.context = extensionContext;
    }

    public void afterAll(ExtensionContext extensionContext) {
        this.context = null;
    }

    public void afterEach(ExtensionContext extensionContext) {
        this.shutdown();
        this.context = null;
    }

    public void beforeEach(ExtensionContext extensionContext) {
        this.context = extensionContext;
        this.initialize();
    }
}

