/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.ftp.services.embedded;

import org.apache.camel.test.infra.ftp.services.embedded.EmbeddedConfiguration;

public final class EmbeddedConfigurationBuilder {
    private final EmbeddedConfiguration embeddedConfiguration = new EmbeddedConfiguration();

    private EmbeddedConfigurationBuilder() {
    }

    public EmbeddedConfigurationBuilder withTestDirectory(String testDirectory) {
        this.embeddedConfiguration.setTestDirectory(testDirectory);
        return this;
    }

    public EmbeddedConfigurationBuilder addUser(EmbeddedConfiguration.User user) {
        this.embeddedConfiguration.addUser(user);
        return this;
    }

    public EmbeddedConfigurationBuilder addUser(String username, String password, EmbeddedConfiguration.User.UserInfo userInfo) {
        this.embeddedConfiguration.addUser(new EmbeddedConfiguration.User(username, password, userInfo));
        return this;
    }

    public EmbeddedConfigurationBuilder withAdmin(EmbeddedConfiguration.User adminUser) {
        this.embeddedConfiguration.setAdmin(adminUser);
        return this;
    }

    public EmbeddedConfigurationBuilder withAdmin(String username, String password, EmbeddedConfiguration.User.UserInfo userInfo) {
        this.embeddedConfiguration.setAdmin(username, password, userInfo);
        return this;
    }

    public EmbeddedConfigurationBuilder withServerAddress(String address) {
        this.embeddedConfiguration.setServerAddress(address);
        return this;
    }

    public EmbeddedConfigurationBuilder withKeyStore(String keyStore) {
        this.embeddedConfiguration.setKeyStore(keyStore);
        return this;
    }

    public EmbeddedConfigurationBuilder withKeyStorePassword(String keyStorePassword) {
        this.embeddedConfiguration.setKeyStorePassword(keyStorePassword);
        return this;
    }

    public EmbeddedConfigurationBuilder withKeyStoreType(String keyStoreType) {
        this.embeddedConfiguration.setKeyStoreType(keyStoreType);
        return this;
    }

    public EmbeddedConfigurationBuilder withKeyStoreAlgorithm(String keyStoreAlgorithm) {
        this.embeddedConfiguration.setKeyStoreAlgorithm(keyStoreAlgorithm);
        return this;
    }

    public EmbeddedConfigurationBuilder withKnownHosts(String knownHosts) {
        this.embeddedConfiguration.setKnownHosts(knownHosts);
        return this;
    }

    public EmbeddedConfigurationBuilder withKnownHostsPath(String knownHostsPath) {
        this.embeddedConfiguration.setKnownHostsPath(knownHostsPath);
        return this;
    }

    public EmbeddedConfigurationBuilder withKeyPairFile(String keyPairFile) {
        this.embeddedConfiguration.setKeyPairFile(keyPairFile);
        return this;
    }

    public EmbeddedConfigurationBuilder withSecurityConfiguration(boolean useImplicit, String authValue, boolean clientAuth) {
        return this.withSecurityConfiguration(new EmbeddedConfiguration.SecurityConfiguration(useImplicit, authValue, clientAuth));
    }

    public EmbeddedConfigurationBuilder withSecurityConfiguration(EmbeddedConfiguration.SecurityConfiguration securityConfiguration) {
        this.embeddedConfiguration.setSecurityConfiguration(securityConfiguration);
        return this;
    }

    public EmbeddedConfiguration build() {
        return this.embeddedConfiguration;
    }

    public static EmbeddedConfigurationBuilder defaultConfigurationTemplate() {
        EmbeddedConfiguration.User.UserInfo writableUser = new EmbeddedConfiguration.User.UserInfo(null, true);
        EmbeddedConfiguration.User.UserInfo nonWritableUser = new EmbeddedConfiguration.User.UserInfo(null, false);
        EmbeddedConfigurationBuilder builder = new EmbeddedConfigurationBuilder().withTestDirectory("res/home").addUser("admin", "admin", writableUser).addUser("scott", "tiger", writableUser).addUser("dummy", "foo", nonWritableUser).addUser("us@r", "t%st", writableUser).addUser("anonymous", null, nonWritableUser).addUser("joe", "p+%w0&r)d", writableUser).addUser("jane", "%j#7%c6i", writableUser).withAdmin("admin", null, null).withServerAddress("localhost");
        return builder;
    }

    public static EmbeddedConfiguration defaultConfiguration() {
        return EmbeddedConfigurationBuilder.defaultConfigurationTemplate().build();
    }

    public static EmbeddedConfigurationBuilder defaultFtpsConfigurationTemplate() {
        EmbeddedConfiguration.User.UserInfo writableUser = new EmbeddedConfiguration.User.UserInfo(null, true);
        EmbeddedConfiguration.User.UserInfo nonWritableUser = new EmbeddedConfiguration.User.UserInfo(null, false);
        EmbeddedConfigurationBuilder builder = new EmbeddedConfigurationBuilder().withTestDirectory("res/home").addUser("admin", "admin", writableUser).addUser("scott", "tiger", writableUser).addUser("dummy", "foo", nonWritableUser).addUser("us@r", "t%st", writableUser).addUser("anonymous", null, nonWritableUser).addUser("joe", "p+%w0&r)d", writableUser).addUser("jane", "%j#7%c6i", writableUser).withAdmin("admin", null, null).withServerAddress("localhost").withKeyStore("./src/test/resources/server.jks").withKeyStorePassword("password").withKeyStoreType("JKS").withKeyStoreAlgorithm("SunX509");
        return builder;
    }

    public static EmbeddedConfiguration defaultFtpsConfiguration() {
        return EmbeddedConfigurationBuilder.defaultFtpsConfigurationTemplate().build();
    }

    public static EmbeddedConfiguration defaultSftpConfiguration() {
        EmbeddedConfiguration.User.UserInfo writableUser = new EmbeddedConfiguration.User.UserInfo(null, true);
        EmbeddedConfiguration.User.UserInfo nonWritableUser = new EmbeddedConfiguration.User.UserInfo(null, false);
        EmbeddedConfigurationBuilder builder = new EmbeddedConfigurationBuilder().withTestDirectory("res/home").addUser("admin", "admin", writableUser).addUser("scott", "tiger", writableUser).addUser("dummy", "foo", nonWritableUser).addUser("us@r", "t%st", writableUser).addUser("anonymous", null, nonWritableUser).addUser("joe", "p+%w0&r)d", writableUser).addUser("jane", "%j#7%c6i", writableUser).withAdmin("admin", null, null).withServerAddress("localhost").withKeyStore("./src/test/resources/server.jks").withKeyStorePassword("password").withKeyStoreType("JKS").withKeyStoreAlgorithm("SunX509").withKnownHosts("[localhost]:%d ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAAAgQDdfIWeSV4o68dRrKSzFd/Bk51E65UTmmSrmW0O1ohtzi6HzsDPjXgCtlTt3FqTcfFfI92IlTr4JWqC9UK1QT1ZTeng0MkPQmv68hDANHbt5CpETZHjW5q4OOgWhVvj5IyOC2NZHtKlJBkdsMAa15ouOOJLzBvAvbqOR/yUROsEiQ==").withKnownHostsPath("user-home/.ssh/known_hosts").withKeyPairFile("src/test/resources/hostkey.pem");
        return builder.embeddedConfiguration;
    }
}

