/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.ftp.services.embedded;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.camel.test.infra.common.services.AbstractTestService;
import org.apache.camel.test.infra.ftp.services.FtpService;
import org.apache.camel.test.infra.ftp.services.embedded.EmbeddedConfiguration;
import org.apache.camel.test.infra.ftp.services.embedded.EmbeddedConfigurationBuilder;
import org.apache.commons.io.FileUtils;
import org.apache.ftpserver.ConnectionConfigFactory;
import org.apache.ftpserver.FtpServer;
import org.apache.ftpserver.FtpServerFactory;
import org.apache.ftpserver.filesystem.nativefs.NativeFileSystemFactory;
import org.apache.ftpserver.ftplet.FileSystemFactory;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.impl.DefaultFtpServer;
import org.apache.ftpserver.impl.FtpIoSession;
import org.apache.ftpserver.listener.Listener;
import org.apache.ftpserver.listener.ListenerFactory;
import org.apache.ftpserver.usermanager.ClearTextPasswordEncryptor;
import org.apache.ftpserver.usermanager.PasswordEncryptor;
import org.apache.ftpserver.usermanager.PropertiesUserManagerFactory;
import org.apache.ftpserver.usermanager.impl.BaseUser;
import org.apache.ftpserver.usermanager.impl.WritePermission;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpEmbeddedService
extends AbstractTestService
implements FtpService {
    protected static final String DEFAULT_LISTENER = "default";
    private static final Logger LOG = LoggerFactory.getLogger(FtpEmbeddedService.class);
    protected FtpServer ftpServer;
    protected int port;
    protected Path rootDir;
    private final EmbeddedConfigurationBuilder embeddedConfigurationTemplate;
    private ExtensionContext context;

    public FtpEmbeddedService() {
        this(EmbeddedConfigurationBuilder.defaultConfigurationTemplate());
    }

    protected FtpEmbeddedService(EmbeddedConfigurationBuilder embeddedConfigurationTemplate) {
        this.embeddedConfigurationTemplate = embeddedConfigurationTemplate;
    }

    protected void setUp() throws Exception {
        this.embeddedConfigurationTemplate.withTestDirectory(this.context.getDisplayName().replace("()", ""));
        EmbeddedConfiguration embeddedConfiguration = this.embeddedConfigurationTemplate.build();
        this.rootDir = this.testDirectory().resolve(embeddedConfiguration.getTestDirectory());
        FileUtils.deleteDirectory((File)this.rootDir.toFile());
        FtpServerFactory factory = this.createFtpServerFactory(embeddedConfiguration);
        this.ftpServer = factory.createServer();
        this.ftpServer.start();
        this.port = this.getListenerPort();
    }

    private int getListenerPort() {
        return ((DefaultFtpServer)this.ftpServer).getListeners().values().stream().map(Listener::getPort).findAny().get();
    }

    @Deprecated
    private Path testDirectory() {
        return Paths.get("target", "ftp", this.context.getRequiredTestClass().getSimpleName());
    }

    protected void createUser(UserManager userMgr, String name, String password, Path home, boolean writePermission) {
        try {
            BaseUser user = new BaseUser();
            user.setName(name);
            user.setPassword(password);
            user.setHomeDirectory(home.toString());
            if (writePermission) {
                user.setAuthorities(Collections.singletonList(new WritePermission()));
            }
            userMgr.save((User)user);
        }
        catch (FtpException e) {
            throw new IllegalStateException("Unable to create FTP user", e);
        }
    }

    protected FtpServerFactory createFtpServerFactory(EmbeddedConfiguration embeddedConfiguration) {
        NativeFileSystemFactory fsf = new NativeFileSystemFactory();
        fsf.setCreateHome(true);
        PropertiesUserManagerFactory pumf = new PropertiesUserManagerFactory();
        pumf.setAdminName(embeddedConfiguration.getAdmin().getUsername());
        pumf.setPasswordEncryptor((PasswordEncryptor)new ClearTextPasswordEncryptor());
        pumf.setFile(null);
        UserManager userMgr = pumf.createUserManager();
        for (EmbeddedConfiguration.User user : embeddedConfiguration.getUsers()) {
            EmbeddedConfiguration.User.UserInfo userInfo = user.getUserInfo();
            Path homeDir = userInfo.getHome() == null ? this.rootDir : Path.of(userInfo.getHome(), new String[0]);
            this.createUser(userMgr, user.getUsername(), user.getPassword(), homeDir, userInfo.isWritePermission());
        }
        FtpServerFactory serverFactory = new FtpServerFactory();
        serverFactory.setUserManager(userMgr);
        serverFactory.setFileSystem((FileSystemFactory)fsf);
        serverFactory.setConnectionConfig(new ConnectionConfigFactory().createConnectionConfig());
        ListenerFactory factory = new ListenerFactory();
        factory.setPort(this.port);
        factory.setServerAddress(embeddedConfiguration.getServerAddress());
        Listener listener = factory.createListener();
        serverFactory.addListener(DEFAULT_LISTENER, listener);
        return serverFactory;
    }

    protected void tearDown() {
        try {
            if (this.ftpServer != null) {
                this.ftpServer.stop();
            }
        }
        catch (Exception e) {
            LOG.trace("Exception while shutting down: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            this.ftpServer = null;
        }
    }

    public void disconnectAllSessions() {
        Map listeners = ((DefaultFtpServer)this.ftpServer).getListeners();
        for (Listener listener : listeners.values()) {
            Set sessions = listener.getActiveSessions();
            for (FtpIoSession session : sessions) {
                session.closeNow();
            }
        }
    }

    protected void registerProperties(BiConsumer<String, String> store) {
        String host = ((DefaultFtpServer)this.ftpServer).getListeners().values().stream().map(Listener::getServerAddress).findAny().get();
        store.accept("ftp.server.host", host);
        store.accept("ftp.server.port", String.valueOf(this.getPort()));
        store.accept("ftp.root.dir", this.rootDir.toString());
    }

    public void registerProperties() {
        ExtensionContext.Store store = this.context.getStore(ExtensionContext.Namespace.GLOBAL);
        this.registerProperties((arg_0, arg_1) -> ((ExtensionContext.Store)store).put(arg_0, arg_1));
    }

    @Override
    public Path getFtpRootDir() {
        return this.rootDir;
    }

    public void resume() {
        this.ftpServer.resume();
        this.port = this.getListenerPort();
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public int countConnections() {
        int count = 0;
        Map listeners = ((DefaultFtpServer)this.ftpServer).getListeners();
        for (Listener listener : listeners.values()) {
            count += listener.getActiveSessions().size();
        }
        return count;
    }

    public void beforeAll(ExtensionContext extensionContext) {
        this.context = extensionContext;
    }

    public void afterAll(ExtensionContext extensionContext) {
        this.context = null;
    }

    public void afterEach(ExtensionContext extensionContext) {
        this.shutdown();
        this.context = null;
    }

    public void beforeEach(ExtensionContext extensionContext) {
        this.context = extensionContext;
        this.initialize();
    }

    public Path ftpFile(String file) {
        return this.getFtpRootDir().resolve(file);
    }
}

