/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.fhir.services;

import org.apache.camel.test.infra.common.services.SimpleTestServiceBuilder;
import org.apache.camel.test.infra.fhir.services.FhirLocalContainerService;
import org.apache.camel.test.infra.fhir.services.FhirLocalSingletonContainerService;
import org.apache.camel.test.infra.fhir.services.FhirRemoteService;
import org.apache.camel.test.infra.fhir.services.FhirService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FhirServiceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(FhirServiceFactory.class);

    private FhirServiceFactory() {
    }

    public static SimpleTestServiceBuilder<FhirService> builder() {
        return new SimpleTestServiceBuilder("fhir");
    }

    public static FhirService createService() {
        return (FhirService)FhirServiceFactory.builder().addLocalMapping(FhirLocalContainerService::new).addRemoteMapping(FhirRemoteService::new).build();
    }

    public static FhirService createSingletonService() {
        return (FhirService)FhirServiceFactory.builder().addLocalMapping(() -> new FhirLocalSingletonContainerService()).addRemoteMapping(FhirRemoteService::new).build();
    }
}

