/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.elasticsearch.services;

import java.util.Optional;
import javax.net.ssl.SSLContext;
import org.apache.camel.test.infra.common.services.SimpleTestServiceBuilder;
import org.apache.camel.test.infra.common.services.SingletonService;
import org.apache.camel.test.infra.common.services.TestService;
import org.apache.camel.test.infra.elasticsearch.services.ElasticSearchLocalContainerService;
import org.apache.camel.test.infra.elasticsearch.services.ElasticSearchService;
import org.apache.camel.test.infra.elasticsearch.services.RemoteElasticSearchService;

public final class ElasticSearchServiceFactory {
    private ElasticSearchServiceFactory() {
    }

    public static SimpleTestServiceBuilder<ElasticSearchService> builder() {
        return new SimpleTestServiceBuilder("elasticsearch");
    }

    public static ElasticSearchService createService() {
        return (ElasticSearchService)ElasticSearchServiceFactory.builder().addLocalMapping(ElasticSearchLocalContainerService::new).addRemoteMapping(RemoteElasticSearchService::new).build();
    }

    public static ElasticSearchService createSingletonService() {
        return SingletonServiceHolder.INSTANCE;
    }

    private static class SingletonServiceHolder {
        static final ElasticSearchService INSTANCE;

        private SingletonServiceHolder() {
        }

        static {
            SimpleTestServiceBuilder<ElasticSearchService> instance = ElasticSearchServiceFactory.builder();
            instance.addLocalMapping(() -> new SingletonElasticSearchService(new ElasticSearchLocalContainerService(), "elastic")).addRemoteMapping(RemoteElasticSearchService::new);
            INSTANCE = (ElasticSearchService)instance.build();
        }
    }

    static class SingletonElasticSearchService
    extends SingletonService<ElasticSearchService>
    implements ElasticSearchService {
        public SingletonElasticSearchService(ElasticSearchService service, String name) {
            super((TestService)service, name);
        }

        @Override
        public int getPort() {
            return ((ElasticSearchService)this.getService()).getPort();
        }

        @Override
        public String getElasticSearchHost() {
            return ((ElasticSearchService)this.getService()).getElasticSearchHost();
        }

        @Override
        public String getHttpHostAddress() {
            return ((ElasticSearchService)this.getService()).getHttpHostAddress();
        }

        @Override
        public Optional<String> getCertificatePath() {
            return ((ElasticSearchService)this.getService()).getCertificatePath();
        }

        @Override
        public Optional<SSLContext> getSslContext() {
            return ((ElasticSearchService)this.getService()).getSslContext();
        }

        @Override
        public String getUsername() {
            return ((ElasticSearchService)this.getService()).getUsername();
        }

        @Override
        public String getPassword() {
            return ((ElasticSearchService)this.getService()).getPassword();
        }
    }
}

