/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.couchdb.services;

import org.apache.camel.test.infra.common.services.SimpleTestServiceBuilder;
import org.apache.camel.test.infra.common.services.SingletonService;
import org.apache.camel.test.infra.common.services.TestService;
import org.apache.camel.test.infra.couchdb.services.CouchDbLocalContainerService;
import org.apache.camel.test.infra.couchdb.services.CouchDbRemoteService;
import org.apache.camel.test.infra.couchdb.services.CouchDbService;

public final class CouchDbServiceFactory {
    private CouchDbServiceFactory() {
    }

    public static SimpleTestServiceBuilder<CouchDbService> builder() {
        return new SimpleTestServiceBuilder("consul");
    }

    public static CouchDbService createService() {
        return (CouchDbService)CouchDbServiceFactory.builder().addLocalMapping(CouchDbLocalContainerService::new).addRemoteMapping(CouchDbRemoteService::new).build();
    }

    public static CouchDbService createSingletonService() {
        return SingletonServiceHolder.INSTANCE;
    }

    private static class SingletonServiceHolder {
        static final CouchDbService INSTANCE;

        private SingletonServiceHolder() {
        }

        static {
            SimpleTestServiceBuilder<CouchDbService> instance = CouchDbServiceFactory.builder();
            instance.addLocalMapping(() -> new SingletonCouchDbService(new CouchDbLocalContainerService(), "couchdb")).addRemoteMapping(CouchDbRemoteService::new);
            INSTANCE = (CouchDbService)instance.build();
        }
    }

    static class SingletonCouchDbService
    extends SingletonService<CouchDbService>
    implements CouchDbService {
        public SingletonCouchDbService(CouchDbService service, String name) {
            super((TestService)service, name);
        }

        @Override
        public String host() {
            return ((CouchDbService)this.getService()).host();
        }

        @Override
        public int port() {
            return ((CouchDbService)this.getService()).port();
        }

        @Override
        public String getServiceAddress() {
            return ((CouchDbService)this.getService()).getServiceAddress();
        }
    }
}

