/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.couchdb.services;

import org.apache.camel.test.infra.common.services.SimpleTestServiceBuilder;
import org.apache.camel.test.infra.common.services.SingletonService;
import org.apache.camel.test.infra.common.services.TestService;
import org.apache.camel.test.infra.couchdb.services.CouchDbLocalContainerService;
import org.apache.camel.test.infra.couchdb.services.CouchDbRemoteService;
import org.apache.camel.test.infra.couchdb.services.CouchDbService;
import org.junit.jupiter.api.extension.ExtensionContext;

public final class CouchDbServiceFactory {
    private static SimpleTestServiceBuilder<CouchDbService> instance;
    private static CouchDbService service;

    private CouchDbServiceFactory() {
    }

    public static SimpleTestServiceBuilder<CouchDbService> builder() {
        return new SimpleTestServiceBuilder("consul");
    }

    public static CouchDbService createService() {
        return (CouchDbService)CouchDbServiceFactory.builder().addLocalMapping(CouchDbLocalContainerService::new).addRemoteMapping(CouchDbRemoteService::new).build();
    }

    public static CouchDbService createSingletonService() {
        if (service == null) {
            if (instance == null) {
                instance = CouchDbServiceFactory.builder();
                instance.addLocalMapping(() -> new SingletonCouchDbService(new CouchDbLocalContainerService(), "couchdb")).addRemoteMapping(CouchDbRemoteService::new);
            }
            service = (CouchDbService)instance.build();
        }
        return service;
    }

    static class SingletonCouchDbService
    extends SingletonService<CouchDbService>
    implements CouchDbService {
        public SingletonCouchDbService(CouchDbService service, String name) {
            super((TestService)service, name);
        }

        @Override
        public void beforeAll(ExtensionContext extensionContext) {
            this.addToStore(extensionContext);
        }

        @Override
        public void afterAll(ExtensionContext extensionContext) {
        }

        @Override
        public String host() {
            return ((CouchDbService)this.getService()).host();
        }

        @Override
        public int port() {
            return ((CouchDbService)this.getService()).port();
        }

        @Override
        public String getServiceAddress() {
            return ((CouchDbService)this.getService()).getServiceAddress();
        }
    }
}

