/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.couchbase.services;

import org.apache.camel.test.infra.common.services.SimpleTestServiceBuilder;
import org.apache.camel.test.infra.common.services.SingletonService;
import org.apache.camel.test.infra.common.services.TestService;
import org.apache.camel.test.infra.couchbase.services.CouchbaseLocalContainerService;
import org.apache.camel.test.infra.couchbase.services.CouchbaseRemoteService;
import org.apache.camel.test.infra.couchbase.services.CouchbaseService;

public final class CouchbaseServiceFactory {
    private CouchbaseServiceFactory() {
    }

    public static SimpleTestServiceBuilder<CouchbaseService> builder() {
        return new SimpleTestServiceBuilder("couchbase");
    }

    public static CouchbaseService createService() {
        return (CouchbaseService)CouchbaseServiceFactory.builder().addLocalMapping(CouchbaseLocalContainerService::new).addRemoteMapping(CouchbaseRemoteService::new).build();
    }

    public static CouchbaseService createSingletonService() {
        return SingletonServiceHolder.INSTANCE;
    }

    @Deprecated
    public static CouchbaseService getService() {
        return CouchbaseServiceFactory.createService();
    }

    private static class SingletonServiceHolder {
        static final CouchbaseService INSTANCE;

        private SingletonServiceHolder() {
        }

        static {
            SimpleTestServiceBuilder<CouchbaseService> instance = CouchbaseServiceFactory.builder();
            instance.addLocalMapping(() -> new SingletonCouchbaseService(new CouchbaseLocalContainerService(), "couchbase")).addRemoteMapping(CouchbaseRemoteService::new);
            INSTANCE = (CouchbaseService)instance.build();
        }
    }

    static class SingletonCouchbaseService
    extends SingletonService<CouchbaseService>
    implements CouchbaseService {
        public SingletonCouchbaseService(CouchbaseService service, String name) {
            super((TestService)service, name);
        }

        @Override
        public String getConnectionString() {
            return ((CouchbaseService)this.getService()).getConnectionString();
        }

        @Override
        public String getUsername() {
            return ((CouchbaseService)this.getService()).getUsername();
        }

        @Override
        public String getPassword() {
            return ((CouchbaseService)this.getService()).getPassword();
        }

        @Override
        public String getHostname() {
            return ((CouchbaseService)this.getService()).getHostname();
        }

        @Override
        public int getPort() {
            return ((CouchbaseService)this.getService()).getPort();
        }
    }
}

