/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.couchbase.services;

import org.apache.camel.test.infra.common.services.SimpleTestServiceBuilder;
import org.apache.camel.test.infra.common.services.SingletonService;
import org.apache.camel.test.infra.common.services.TestService;
import org.apache.camel.test.infra.couchbase.services.CouchbaseLocalContainerService;
import org.apache.camel.test.infra.couchbase.services.CouchbaseRemoteService;
import org.apache.camel.test.infra.couchbase.services.CouchbaseService;
import org.junit.jupiter.api.extension.ExtensionContext;

public final class CouchbaseServiceFactory {
    private static SimpleTestServiceBuilder<CouchbaseService> instance;
    private static CouchbaseService service;

    private CouchbaseServiceFactory() {
    }

    public static SimpleTestServiceBuilder<CouchbaseService> builder() {
        return new SimpleTestServiceBuilder("couchbase");
    }

    public static CouchbaseService createService() {
        return (CouchbaseService)CouchbaseServiceFactory.builder().addLocalMapping(CouchbaseLocalContainerService::new).addRemoteMapping(CouchbaseRemoteService::new).build();
    }

    public static synchronized CouchbaseService createSingletonService() {
        if (service == null) {
            if (instance == null) {
                instance = CouchbaseServiceFactory.builder();
                instance.addLocalMapping(() -> new SingletonCouchbaseService(new CouchbaseLocalContainerService(), "couchbase")).addRemoteMapping(CouchbaseRemoteService::new);
            }
            service = (CouchbaseService)instance.build();
        }
        return service;
    }

    @Deprecated
    public static CouchbaseService getService() {
        return CouchbaseServiceFactory.createService();
    }

    static class SingletonCouchbaseService
    extends SingletonService<CouchbaseService>
    implements CouchbaseService {
        public SingletonCouchbaseService(CouchbaseService service, String name) {
            super((TestService)service, name);
        }

        @Override
        public void beforeAll(ExtensionContext extensionContext) {
            this.addToStore(extensionContext);
        }

        @Override
        public String getConnectionString() {
            return ((CouchbaseService)this.getService()).getConnectionString();
        }

        @Override
        public String getUsername() {
            return ((CouchbaseService)this.getService()).getUsername();
        }

        @Override
        public String getPassword() {
            return ((CouchbaseService)this.getService()).getPassword();
        }

        @Override
        public String getHostname() {
            return ((CouchbaseService)this.getService()).getHostname();
        }

        @Override
        public int getPort() {
            return ((CouchbaseService)this.getService()).getPort();
        }

        @Override
        public void afterAll(ExtensionContext extensionContext) {
        }
    }
}

