/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.consul.services;

import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.consul.services.ConsulService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class ConsulLocalContainerService
implements ConsulService,
ContainerService<GenericContainer> {
    public static final String CONTAINER_IMAGE = "consul:1.11.2";
    public static final String CONTAINER_NAME = "consul";
    private static final Logger LOG = LoggerFactory.getLogger(ConsulLocalContainerService.class);
    private final GenericContainer container;

    public ConsulLocalContainerService() {
        this(System.getProperty("consul.container", CONTAINER_IMAGE));
    }

    public ConsulLocalContainerService(String containerName) {
        this.container = this.initContainer(containerName, CONTAINER_NAME);
    }

    public ConsulLocalContainerService(GenericContainer container) {
        this.container = container;
    }

    protected GenericContainer initContainer(String imageName, String containerName) {
        return new GenericContainer(imageName).withNetworkAliases(new String[]{containerName}).withExposedPorts(new Integer[]{8500}).waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Synced node info.*", (int)1)).withCommand(new String[]{"agent", "-dev", "-server", "-bootstrap", "-client", "0.0.0.0", "-log-level", "trace"});
    }

    public void registerProperties() {
        System.setProperty("consul.url", this.getConsulUrl());
        System.setProperty("consul.host", this.host());
        System.setProperty("consul.port", String.valueOf(this.port()));
    }

    public void initialize() {
        LOG.info("Trying to start the Consul container");
        this.container.start();
        this.registerProperties();
        LOG.info("Consul instance running at {}", (Object)this.getConsulUrl());
    }

    public void shutdown() {
        LOG.info("Stopping the Consul container");
        this.container.stop();
    }

    public GenericContainer getContainer() {
        return this.container;
    }

    @Override
    public String getConsulUrl() {
        return String.format("http://%s:%d", this.container.getHost(), this.container.getMappedPort(8500));
    }

    @Override
    public String host() {
        return this.container.getHost();
    }

    @Override
    public int port() {
        return this.container.getMappedPort(8500);
    }
}

