/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.common;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.testcontainers.containers.output.BaseConsumer;
import org.testcontainers.containers.output.OutputFrame;

public class CamelLogConsumer
extends BaseConsumer<CamelLogConsumer> {
    private final Path logFile;
    private final boolean logToStdout;

    public CamelLogConsumer(Path logFile, boolean logToStdout) {
        this.logFile = logFile;
        this.logToStdout = logToStdout;
    }

    public void accept(OutputFrame outputFrame) {
        OutputFrame.OutputType outputType = outputFrame.getType();
        String utf8String = outputFrame.getUtf8StringWithoutLineEnding();
        switch (outputType) {
            case END: {
                break;
            }
            case STDOUT: {
                if (this.logToStdout) {
                    System.out.println(utf8String);
                }
                this.logToFile(utf8String);
                break;
            }
            case STDERR: {
                if (this.logToStdout) {
                    System.err.println(utf8String);
                }
                this.logToFile(utf8String);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected outputType " + String.valueOf(outputType));
            }
        }
    }

    private void logToFile(String utf8String) {
        try {
            Files.write(this.logFile, (utf8String + System.lineSeparator()).getBytes(), StandardOpenOption.APPEND);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

