/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.common.services;

import org.apache.camel.spi.annotations.InfraService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.GenericContainer;

public final class ContainerEnvironmentUtil {
    public static final String STARTUP_ATTEMPTS_PROPERTY = ".startup.attempts";
    private static final Logger LOG = LoggerFactory.getLogger(ContainerEnvironmentUtil.class);
    private static boolean dockerAvailable;
    private static boolean environmentCheckState;

    private ContainerEnvironmentUtil() {
    }

    public static synchronized boolean isDockerAvailable() {
        if (!environmentCheckState) {
            try {
                dockerAvailable = DockerClientFactory.instance().isDockerAvailable();
                if (!dockerAvailable) {
                    LOG.warn("Docker environment is not available");
                }
            }
            catch (Exception e) {
                LOG.error("Failed to evaluate whether the docker environment is available: {}", (Object)e.getMessage(), (Object)e);
                LOG.warn("Turning off container-based tests because docker does not seem to be working correctly");
                dockerAvailable = false;
            }
            environmentCheckState = true;
        }
        return dockerAvailable;
    }

    public static void configureContainerStartup(GenericContainer<?> container, String property, int defaultValue) {
        int startupAttempts = Integer.valueOf(System.getProperty(property, String.valueOf(defaultValue)));
        container.setStartupAttempts(startupAttempts);
    }

    public static boolean isFixedPort(Class cls) {
        for (Class<?> i : cls.getInterfaces()) {
            if (!i.getName().contains("InfraService")) continue;
            LOG.debug("Service {} will use fixed ports (detected InfraService interface: {})", (Object)cls.getSimpleName(), (Object)i.getSimpleName());
            return true;
        }
        LOG.debug("Service {} will use random ports (no InfraService interface detected)", (Object)cls.getSimpleName());
        return false;
    }

    public static String containerName(Class cls) {
        InfraService annotation = ContainerEnvironmentUtil.findAnnotation(cls);
        String name = null;
        if (annotation != null) {
            name = "camel-" + annotation.serviceAlias()[0];
            if (annotation.serviceImplementationAlias().length > 0) {
                name = name + "-" + annotation.serviceImplementationAlias()[0];
            }
        } else {
            LOG.warn("InfraService annotation not Found to determine container name alias.");
        }
        return name;
    }

    private static InfraService findAnnotation(Class cls) {
        InfraService annotation = cls.getAnnotation(InfraService.class);
        Class targetClass = cls;
        while (annotation == null && targetClass.getSuperclass() != null && (annotation = (targetClass = targetClass.getSuperclass()).getAnnotation(InfraService.class)) == null) {
        }
        return annotation;
    }
}

