/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.cli.services;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.test.infra.cli.services.CliBuiltContainer;
import org.apache.camel.test.infra.cli.services.CliService;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Container;
import org.testcontainers.shaded.org.apache.commons.lang3.StringUtils;

public class CliLocalContainerService
implements CliService,
ContainerService<CliBuiltContainer> {
    public static final String CONTAINER_NAME = "camel-cli";
    private static final Logger LOG = LoggerFactory.getLogger(CliLocalContainerService.class);
    private final CliBuiltContainer container;
    private String version;
    private String forceToRunVersion;
    private String mavenRepos;

    public CliLocalContainerService() {
        this(System.getProperty("cli.service.version", "main"), true, System.getProperty("cli.service.data.folder"), System.getProperty("cli.service.ssh.password", "jbang"), System.getProperty("cli.service.execute.version", ""), System.getProperty("cli.service.mvn.repos"), CliLocalContainerService.getHostsMap(), CliLocalContainerService.getCertPaths());
    }

    protected CliLocalContainerService(String camelRef, Boolean keepRunning, String dataFolder, String sshPassword, String forceToRunVersion, String mavenRepos, Map<String, String> extraHosts, List<String> trustedCertPaths) {
        this.container = new CliBuiltContainer(camelRef, keepRunning, dataFolder, sshPassword, extraHosts, trustedCertPaths);
        this.forceToRunVersion = forceToRunVersion;
        this.mavenRepos = mavenRepos;
    }

    public void registerProperties() {
    }

    public void initialize() {
        if (!this.container.isRunning()) {
            LOG.info("Trying to start the {} container", (Object)CONTAINER_NAME);
            this.container.start();
            this.registerProperties();
            LOG.info("{} instance running", (Object)CONTAINER_NAME);
            if (StringUtils.isNotBlank((CharSequence)this.forceToRunVersion)) {
                LOG.info("force to use version {}", (Object)this.forceToRunVersion);
                this.execute("version set " + this.forceToRunVersion);
            }
            if (StringUtils.isNotBlank((CharSequence)this.mavenRepos)) {
                LOG.info("set repositories {}", (Object)this.mavenRepos);
                this.execute(String.format("config set repos=%s", this.mavenRepos));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Camel JBang version {}", (Object)this.version());
            }
        } else {
            LOG.debug("the container is already running");
        }
    }

    public void shutdown() {
        if (this.container.isRunning()) {
            LOG.info("Stopping the {} container", (Object)CONTAINER_NAME);
            this.container.stop();
        } else {
            LOG.debug("the container is already stopped");
        }
    }

    public CliBuiltContainer getContainer() {
        return this.container;
    }

    @Override
    public String execute(String command) {
        return this.executeGenericCommand(String.format("camel %s", command));
    }

    @Override
    public String executeBackground(String command) {
        return StringUtils.substringAfter((String)this.execute(command.concat(" --background")), (String)"PID:").trim();
    }

    @Override
    public String executeGenericCommand(String command) {
        try {
            LOG.debug("executing {}", (Object)command);
            Container.ExecResult execResult = this.container.execInContainer(new String[]{"/bin/bash", "-c", command});
            if (execResult.getExitCode() != 0) {
                Assertions.fail((String)String.format("command %s failed with output %s and error %s", command, execResult.getStdout(), execResult.getStderr()));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("result out {}", (Object)execResult.getStdout());
                LOG.debug("result error {}", (Object)execResult.getStderr());
            }
            return execResult.getStdout();
        }
        catch (Exception e) {
            Assertions.fail((String)String.format("command %s failed", command), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void copyFileInternally(String source, String destination) {
        try {
            Assertions.assertEquals((int)0, (int)this.container.execInContainer(String.format("cp %s %s", source, destination).split(" ")).getExitCode(), (String)"copy file exit code");
        }
        catch (IOException | InterruptedException e) {
            Assertions.fail((String)String.format("unable to copy file %s to %s", source, destination), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getMountPoint() {
        return this.container.getMountPoint();
    }

    @Override
    public String getContainerLogs() {
        return this.container.getLogs();
    }

    @Override
    public int getDevConsolePort() {
        return this.container.getMappedPort(8080);
    }

    @Override
    public Stream<String> listDirectory(String directoryPath) {
        try {
            Container.ExecResult result = this.container.execInContainer(new String[]{"ls", "-m", directoryPath});
            Assertions.assertEquals((int)0, (int)result.getExitCode(), (String)"list folder exit code");
            return Arrays.stream(result.getStdout().split(",")).map(String::trim);
        }
        catch (IOException | InterruptedException e) {
            Assertions.fail((String)("unable to list " + directoryPath), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public String id() {
        return this.container.getContainerId().substring(0, 13);
    }

    @Override
    public String version() {
        return Optional.ofNullable(this.version).orElseGet(() -> {
            String versionSummary = this.execute("version");
            if (versionSummary.contains("User configuration") && versionSummary.contains("camel-version = ")) {
                this.version = StringUtils.substringBetween((String)versionSummary, (String)"camel-version = ", (String)"\n").trim();
            }
            if (this.version == null) {
                this.version = StringUtils.substringBetween((String)versionSummary, (String)"Camel JBang version:", (String)"\n").trim();
            }
            return this.version;
        });
    }

    @Override
    public int getSshPort() {
        return this.container.getMappedPort(22);
    }

    @Override
    public String getSshPassword() {
        return this.container.getSshPassword();
    }

    private static Map<String, String> getHostsMap() {
        return Optional.ofNullable(System.getProperty("cli.service.extra.hosts")).map(p -> p.split(",")).stream().flatMap(strings -> Arrays.asList(strings).stream()).map(s -> s.split("=")).collect(Collectors.toMap(entry -> entry[0], entry -> entry[1]));
    }

    private static List<String> getCertPaths() {
        return Optional.ofNullable(System.getProperty("cli.service.trusted.paths")).map(p -> p.split(",")).stream().flatMap(strings -> Arrays.asList(strings).stream()).collect(Collectors.toList());
    }
}

