/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.azure.common.services;

import org.apache.camel.test.infra.azure.common.services.AzureService;
import org.apache.camel.test.infra.azure.common.services.AzuriteContainer;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AzureStorageService
implements AzureService,
ContainerService<AzuriteContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(AzureStorageService.class);
    private final AzuriteContainer container;

    public AzureStorageService() {
        this(System.getProperty("azure.container", "mcr.microsoft.com/azure-storage/azurite:3.20.1"));
    }

    public AzureStorageService(String imageName) {
        this.container = this.initContainer(imageName);
    }

    public AzureStorageService(AzuriteContainer container) {
        this.container = container;
    }

    protected AzuriteContainer initContainer(String imageName) {
        return new AzuriteContainer(imageName);
    }

    public AzuriteContainer getContainer() {
        return this.container;
    }

    public void registerProperties() {
        System.setProperty("azure.storage.account.name", this.container.azureCredentials().accountName());
        System.setProperty("azure.storage.account.key", this.container.azureCredentials().accountKey());
        System.setProperty("azure.storage.host", this.container.getHost());
    }

    public void initialize() {
        this.container.start();
        LOG.info("Azurite local blob service running at address {}:{}", (Object)this.container.getHost(), (Object)this.container.getMappedPort(10000));
        LOG.info("Azurite local queue service running at address {}:{}", (Object)this.container.getHost(), (Object)this.container.getMappedPort(10001));
        this.registerProperties();
    }

    public void shutdown() {
        this.container.stop();
    }
}

