/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.aws2.services;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.camel.test.infra.aws2.common.TestAWSCredentialsProvider;
import org.apache.camel.test.infra.aws2.services.AWSLocalContainerService;
import org.apache.camel.test.infra.aws2.services.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;

public class AWSContainer
extends GenericContainer<AWSContainer> {
    public static final String LOCALSTACK_CONTAINER = "localstack/localstack:1.3.0";
    private static final Logger LOG = LoggerFactory.getLogger(AWSLocalContainerService.class);
    private static final int SERVICE_PORT = 4566;

    public AWSContainer() {
        this(System.getProperty("aws.container", LOCALSTACK_CONTAINER));
    }

    public AWSContainer(String imageName) {
        super(imageName);
    }

    public AWSContainer(String imageName, Service ... services) {
        super(imageName);
        this.setupServices(services);
        this.setupContainer();
    }

    @Deprecated
    protected AWSContainer(String imageName, String serviceList) {
        super(imageName);
        this.setupServices(serviceList);
        this.setupContainer();
    }

    public void setupServices(Service ... services) {
        String serviceList = Arrays.stream(services).map(Service::serviceName).collect(Collectors.joining(","));
        this.setupServices(serviceList);
    }

    public void setupServices(String serviceList) {
        LOG.debug("Creating services {}", (Object)serviceList);
        this.withEnv("SERVICE", serviceList);
    }

    protected void setupContainer() {
        this.withExposedPorts(new Integer[]{4566});
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Ready\\.\n", (int)1));
    }

    public AwsCredentialsProvider getCredentialsProvider() {
        return TestAWSCredentialsProvider.CONTAINER_LOCAL_DEFAULT_PROVIDER;
    }

    protected String getAmazonHost() {
        return this.getHost() + ":" + this.getMappedPort(4566);
    }

    public URI getServiceEndpoint() {
        try {
            String address = String.format("http://%s:%d", this.getHost(), this.getMappedPort(4566));
            LOG.debug("Running on service endpoint: {}", (Object)address);
            return new URI(address);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(String.format("Unable to determine the service endpoint: %s", e.getMessage()), e);
        }
    }
}

