/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.artemis.services;

import org.apache.activemq.artemis.core.server.QueueQueryResult;
import org.apache.camel.test.infra.artemis.services.ArtemisAMQPService;
import org.apache.camel.test.infra.artemis.services.ArtemisMQTTService;
import org.apache.camel.test.infra.artemis.services.ArtemisPersistentVMService;
import org.apache.camel.test.infra.artemis.services.ArtemisService;
import org.apache.camel.test.infra.artemis.services.ArtemisTCPAllProtocolsService;
import org.apache.camel.test.infra.artemis.services.ArtemisVMService;
import org.apache.camel.test.infra.common.services.SimpleTestServiceBuilder;
import org.apache.camel.test.infra.common.services.SingletonService;
import org.apache.camel.test.infra.common.services.TestService;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ArtemisServiceFactory {
    private ArtemisServiceFactory() {
    }

    public static synchronized ArtemisService createVMService() {
        return new ArtemisVMService();
    }

    public static synchronized ArtemisService createPersistentVMService() {
        return new ArtemisPersistentVMService();
    }

    public static ArtemisService createAMQPService() {
        return new ArtemisAMQPService();
    }

    public static ArtemisService createSingletonVMService() {
        return SingletonVMServiceHolder.INSTANCE;
    }

    public static ArtemisService createSingletonPersistentVMService() {
        return SingletonPersistentVMServiceHolder.INSTANCE;
    }

    public static ArtemisService createSingletonAMQPService() {
        return SingletonAMQPServiceHolder.INSTANCE;
    }

    public static ArtemisService createSingletonMQTTService() {
        return SingletonMQTTServiceHolder.INSTANCE;
    }

    public static ArtemisService createTCPAllProtocolsService() {
        return new ArtemisTCPAllProtocolsService();
    }

    private static class SingletonVMServiceHolder {
        static final ArtemisService INSTANCE;

        private SingletonVMServiceHolder() {
        }

        static {
            SimpleTestServiceBuilder nonPersistentInstanceBuilder = new SimpleTestServiceBuilder("artemis");
            nonPersistentInstanceBuilder.addLocalMapping(() -> new SingletonArtemisService(new ArtemisVMService(), "artemis"));
            INSTANCE = (ArtemisService)nonPersistentInstanceBuilder.build();
        }
    }

    private static class SingletonPersistentVMServiceHolder {
        static final ArtemisService INSTANCE;

        private SingletonPersistentVMServiceHolder() {
        }

        static {
            SimpleTestServiceBuilder persistentInstanceBuilder = new SimpleTestServiceBuilder("artemis");
            persistentInstanceBuilder.addLocalMapping(() -> new SingletonArtemisService(new ArtemisPersistentVMService(), "artemis-persistent"));
            INSTANCE = (ArtemisService)persistentInstanceBuilder.build();
        }
    }

    private static class SingletonAMQPServiceHolder {
        static final ArtemisService INSTANCE;

        private SingletonAMQPServiceHolder() {
        }

        static {
            SimpleTestServiceBuilder amqpInstanceBuilder = new SimpleTestServiceBuilder("artemis");
            amqpInstanceBuilder.addLocalMapping(() -> new SingletonArtemisService(new ArtemisAMQPService(), "artemis-amqp"));
            INSTANCE = (ArtemisService)amqpInstanceBuilder.build();
        }
    }

    private static class SingletonMQTTServiceHolder {
        static final ArtemisService INSTANCE;

        private SingletonMQTTServiceHolder() {
        }

        static {
            SimpleTestServiceBuilder mqttInstanceBuilder = new SimpleTestServiceBuilder("artemis");
            mqttInstanceBuilder.addLocalMapping(() -> new SingletonArtemisService(new ArtemisMQTTService(), "artemis-mqtt"));
            INSTANCE = (ArtemisService)mqttInstanceBuilder.build();
        }
    }

    public static class SingletonArtemisService
    extends SingletonService<ArtemisService>
    implements ArtemisService {
        private static final Logger LOG = LoggerFactory.getLogger(SingletonArtemisService.class);

        public SingletonArtemisService(ArtemisService service, String name) {
            super((TestService)service, name);
        }

        @Override
        public String serviceAddress() {
            return this.getService().serviceAddress();
        }

        @Override
        public String userName() {
            return this.getService().userName();
        }

        @Override
        public String password() {
            return this.getService().password();
        }

        @Override
        public int brokerPort() {
            return this.getService().brokerPort();
        }

        @Override
        public final void restart() {
            LOG.error("Singleton services must not be restarted");
            throw new IllegalArgumentException("Singleton services must not be restarted");
        }

        @Override
        public long countMessages(String queue) throws Exception {
            return this.getService().countMessages(queue);
        }

        @Override
        public QueueQueryResult getQueueQueryResult(String queueQuery) throws Exception {
            return this.getService().getQueueQueryResult(queueQuery);
        }

        public ArtemisService getService() {
            return (ArtemisService)super.getService();
        }

        @Override
        public void afterAll(ExtensionContext extensionContext) {
        }

        @Override
        public void beforeAll(ExtensionContext extensionContext) {
            this.addToStore(extensionContext);
        }
    }
}

