/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.artemis.services;

import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.camel.test.infra.artemis.services.AbstractArtemisEmbeddedService;
import org.junit.jupiter.api.Assertions;

public class ArtemisMQTTService
extends AbstractArtemisEmbeddedService {
    private String brokerURL;
    private int port;

    public ArtemisMQTTService(int port) {
        super(port);
    }

    public ArtemisMQTTService() {
    }

    @Override
    protected Configuration configure(Configuration configuration, int port, int brokerId) {
        this.port = port;
        this.brokerURL = "tcp://0.0.0.0:" + port;
        AddressSettings addressSettings = new AddressSettings();
        addressSettings.setAddressFullMessagePolicy(AddressFullMessagePolicy.FAIL);
        try {
            configuration.addAcceptorConfiguration("mqtt", this.brokerURL + "?protocols=MQTT");
            configuration.addAddressSetting("#", addressSettings);
            configuration.setMaxDiskUsage(98);
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            Assertions.fail((String)"mqtt acceptor cannot be configured");
        }
        return configuration;
    }

    @Override
    public String serviceAddress() {
        return this.brokerURL;
    }

    @Override
    public int brokerPort() {
        return this.port;
    }
}

