/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.artemis.common;

import jakarta.jms.ConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.camel.test.infra.artemis.services.AbstractArtemisEmbeddedService;
import org.apache.camel.test.infra.artemis.services.ArtemisInfraService;
import org.apache.camel.test.infra.artemis.services.ServiceAware;
import org.apache.camel.test.infra.messaging.services.ConnectionFactoryAware;

public final class ConnectionFactoryHelper {
    private ConnectionFactoryHelper() {
    }

    public static ConnectionFactory createConnectionFactory(ArtemisInfraService service) {
        return ConnectionFactoryHelper.createConnectionFactory(service, null);
    }

    public static ConnectionFactory createConnectionFactory(ArtemisInfraService service, Integer maximumRedeliveries) {
        if (service instanceof ConnectionFactoryAware) {
            AbstractArtemisEmbeddedService embeddedService = (AbstractArtemisEmbeddedService)service;
            return ConnectionFactoryHelper.createConnectionFactory(embeddedService.serviceAddress(), maximumRedeliveries);
        }
        if (service instanceof ServiceAware) {
            return ConnectionFactoryHelper.createConnectionFactory((ArtemisInfraService)((ServiceAware)((Object)service)).getService(), maximumRedeliveries);
        }
        throw new UnsupportedOperationException(String.format("The test service %s does not implement ConnectionFactoryAware", service.getClass()));
    }

    public static ConnectionFactory createConnectionFactory(String url, Integer maximumRedeliveries) {
        return ConnectionFactoryHelper.createConnectionFactory(new ActiveMQConnectionFactory(url), maximumRedeliveries);
    }

    public static ConnectionFactory createConnectionFactory(ActiveMQConnectionFactory connectionFactory, Integer maximumRedeliveries) {
        return connectionFactory;
    }

    public static ConnectionFactory createPersistentConnectionFactory(String url) {
        return ConnectionFactoryHelper.createPersistentConnectionFactory(new ActiveMQConnectionFactory(url));
    }

    public static ConnectionFactory createPersistentConnectionFactory(ActiveMQConnectionFactory connectionFactory) {
        return connectionFactory;
    }
}

