/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.arangodb.services;

import org.apache.camel.test.infra.arangodb.services.ArangoDBLocalContainerService;
import org.apache.camel.test.infra.arangodb.services.ArangoDBRemoteService;
import org.apache.camel.test.infra.arangodb.services.ArangoDBService;
import org.apache.camel.test.infra.common.services.SimpleTestServiceBuilder;
import org.apache.camel.test.infra.common.services.SingletonService;
import org.apache.camel.test.infra.common.services.TestService;
import org.junit.jupiter.api.extension.ExtensionContext;

public final class ArangoDBServiceFactory {
    private static SimpleTestServiceBuilder<ArangoDBService> instance;
    private static ArangoDBService arangoDBService;

    private ArangoDBServiceFactory() {
    }

    public static SimpleTestServiceBuilder<ArangoDBService> builder() {
        return new SimpleTestServiceBuilder("arangodb");
    }

    public static ArangoDBService createService() {
        return (ArangoDBService)ArangoDBServiceFactory.builder().addLocalMapping(ArangoDBLocalContainerService::new).addRemoteMapping(ArangoDBRemoteService::new).build();
    }

    public static ArangoDBService createSingletonService() {
        if (arangoDBService == null) {
            if (instance == null) {
                instance = ArangoDBServiceFactory.builder();
                instance.addLocalMapping(() -> new SingletonArangoDBService(new ArangoDBLocalContainerService(), "arangoDB")).addRemoteMapping(ArangoDBRemoteService::new).build();
            }
            arangoDBService = (ArangoDBService)instance.build();
        }
        return arangoDBService;
    }

    private static class SingletonArangoDBService
    extends SingletonService<ArangoDBService>
    implements ArangoDBService {
        public SingletonArangoDBService(ArangoDBService service, String name) {
            super((TestService)service, name);
        }

        @Override
        public void beforeAll(ExtensionContext extensionContext) {
            this.addToStore(extensionContext);
        }

        @Override
        public void afterAll(ExtensionContext extensionContext) {
        }

        @Override
        public int getPort() {
            return ((ArangoDBService)this.getService()).getPort();
        }

        @Override
        public String getHost() {
            return ((ArangoDBService)this.getService()).getHost();
        }
    }
}

