/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.activemq.services;

import org.apache.camel.test.infra.activemq.services.ActiveMQEmbeddedService;
import org.apache.camel.test.infra.activemq.services.ActiveMQPersistentVMService;
import org.apache.camel.test.infra.activemq.services.ActiveMQRemoteService;
import org.apache.camel.test.infra.activemq.services.ActiveMQService;
import org.apache.camel.test.infra.activemq.services.ActiveMQVMService;
import org.apache.camel.test.infra.common.services.SimpleTestServiceBuilder;
import org.apache.camel.test.infra.common.services.SingletonService;
import org.apache.camel.test.infra.common.services.TestService;
import org.junit.jupiter.api.extension.ExtensionContext;

public final class ActiveMQServiceFactory {
    private static SimpleTestServiceBuilder<ActiveMQService> nonPersistentInstanceBuilder;
    private static ActiveMQService nonPersistentService;
    private static SimpleTestServiceBuilder<ActiveMQService> persistentInstanceBuilder;
    private static ActiveMQService persistentService;

    private ActiveMQServiceFactory() {
    }

    public static SimpleTestServiceBuilder<ActiveMQService> builder() {
        return new SimpleTestServiceBuilder("activemq");
    }

    public static ActiveMQService createService() {
        return (ActiveMQService)ActiveMQServiceFactory.builder().addLocalMapping(ActiveMQEmbeddedService::new).addRemoteMapping(ActiveMQRemoteService::new).build();
    }

    public static synchronized ActiveMQService createVMService() {
        return ActiveMQServiceFactory.createSingletonVMService();
    }

    public static synchronized ActiveMQService createVMServiceInstance() {
        SimpleTestServiceBuilder instance = new SimpleTestServiceBuilder("activemq");
        instance.addLocalMapping(ActiveMQVMService::new);
        return (ActiveMQService)instance.build();
    }

    public static synchronized ActiveMQService createSingletonVMService() {
        if (nonPersistentService == null) {
            if (nonPersistentInstanceBuilder == null) {
                nonPersistentInstanceBuilder = new SimpleTestServiceBuilder("activemq");
                nonPersistentInstanceBuilder.addLocalMapping(() -> new SingletonActiveMQService(new ActiveMQVMService(), "activemq"));
            }
            nonPersistentService = (ActiveMQService)nonPersistentInstanceBuilder.build();
        }
        return nonPersistentService;
    }

    public static synchronized ActiveMQService createPersistentVMService() {
        return ActiveMQServiceFactory.createSingletonPersistentVMService();
    }

    public static synchronized ActiveMQService createPersistentVMServiceInstance() {
        SimpleTestServiceBuilder instance = new SimpleTestServiceBuilder("activemq");
        instance.addLocalMapping(ActiveMQPersistentVMService::new);
        return (ActiveMQService)instance.build();
    }

    public static synchronized ActiveMQService createSingletonPersistentVMService() {
        if (persistentService == null) {
            if (persistentInstanceBuilder == null) {
                persistentInstanceBuilder = new SimpleTestServiceBuilder("activemq");
                persistentInstanceBuilder.addLocalMapping(() -> new SingletonActiveMQService(new ActiveMQPersistentVMService(), "activemq-persistent"));
            }
            persistentService = (ActiveMQService)persistentInstanceBuilder.build();
        }
        return persistentService;
    }

    public static class SingletonActiveMQService
    extends SingletonService<ActiveMQService>
    implements ActiveMQService {
        public SingletonActiveMQService(ActiveMQService service, String name) {
            super((TestService)service, name);
        }

        @Override
        public String serviceAddress() {
            return this.getService().serviceAddress();
        }

        @Override
        public String userName() {
            return this.getService().userName();
        }

        @Override
        public String password() {
            return this.getService().password();
        }

        @Override
        public void beforeAll(ExtensionContext extensionContext) {
            this.addToStore(extensionContext);
        }

        @Override
        public void afterAll(ExtensionContext extensionContext) {
        }

        @Override
        public void afterEach(ExtensionContext extensionContext) {
        }

        @Override
        public void beforeEach(ExtensionContext extensionContext) {
            this.addToStore(extensionContext);
        }

        @Override
        public void restart() {
            this.getService().restart();
        }

        public ActiveMQService getService() {
            return (ActiveMQService)super.getService();
        }
    }
}

