/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.activemq.services;

import org.apache.camel.test.infra.common.services.TestService;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public interface ActiveMQService
extends BeforeAllCallback,
AfterAllCallback,
TestService {
    public String serviceAddress();

    public String userName();

    public String password();

    default public void registerProperties() {
        System.setProperty("activemq.service.address", this.serviceAddress());
        System.setProperty("amq.external", this.serviceAddress());
        System.setProperty("amq.username", this.userName());
        System.setProperty("amq.password", this.userName());
    }

    default public void beforeAll(ExtensionContext extensionContext) throws Exception {
        this.initialize();
    }

    default public void afterAll(ExtensionContext extensionContext) throws Exception {
        this.shutdown();
    }

    public void restart();
}

