/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.cdi;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Priority;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessBeanAttributes;
import javax.enterprise.inject.spi.WithAnnotations;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.AdviceWith;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.cdi.CdiCamelConfiguration;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.test.cdi.AdviceRoute;
import org.apache.camel.test.cdi.AnnotatedMethodDecorator;
import org.apache.camel.test.cdi.AnnotatedTypeDecorator;
import org.apache.camel.test.cdi.Beans;
import org.apache.camel.test.cdi.PriorityLiteral;

final class CamelCdiTestExtension
implements Extension {
    private final Beans beans;
    private final List<Bean<? extends AdviceWithRouteBuilder>> builderBeans = new CopyOnWriteArrayList<Bean<? extends AdviceWithRouteBuilder>>();

    CamelCdiTestExtension(Beans beans) {
        this.beans = beans;
    }

    <T> void alternatives(@Observes @WithAnnotations(value={Alternative.class}) ProcessAnnotatedType<T> pat) {
        if (this.beans == null) {
            return;
        }
        AnnotatedType type = pat.getAnnotatedType();
        if (!Arrays.asList(this.beans.alternatives()).contains(type.getJavaClass())) {
            return;
        }
        HashSet methods = new HashSet();
        for (AnnotatedMethod method : type.getMethods()) {
            if (!method.isAnnotationPresent(Alternative.class) || method.isAnnotationPresent(Priority.class)) continue;
            methods.add(new AnnotatedMethodDecorator(method, (Annotation)((Object)PriorityLiteral.of(2000))));
        }
        if (type.isAnnotationPresent(Alternative.class) && !type.isAnnotationPresent(Priority.class)) {
            pat.setAnnotatedType(new AnnotatedTypeDecorator(type, (Annotation)((Object)PriorityLiteral.of(2000)), methods));
        } else if (!methods.isEmpty()) {
            pat.setAnnotatedType(new AnnotatedTypeDecorator(type, methods));
        }
    }

    void collectAdviceWithRouteBuilder(@Observes ProcessBeanAttributes<? extends AdviceWithRouteBuilder> event) {
        BeanAttributes beanAttributes;
        if (event.getAnnotated().isAnnotationPresent(AdviceRoute.class) && (beanAttributes = event.getBeanAttributes()) instanceof Bean) {
            this.builderBeans.add((Bean<? extends AdviceWithRouteBuilder>)((Bean)beanAttributes));
            event.veto();
        }
    }

    void disableAutoStartContext(@Observes @Priority(value=0x7FFFFFFF) CdiCamelConfiguration configuration) {
        if (this.builderBeans.isEmpty()) {
            return;
        }
        configuration.autoStartContexts(false);
    }

    void advice(@Observes @Priority(value=0x7FFFFFFF) AfterDeploymentValidation event, BeanManager manager) throws Exception {
        if (this.builderBeans.isEmpty()) {
            return;
        }
        for (Bean beanContext : manager.getBeans(CamelContext.class, new Annotation[]{Any.Literal.INSTANCE})) {
            ModelCamelContext context = (ModelCamelContext)manager.getReference(beanContext, ModelCamelContext.class, manager.createCreationalContext((Contextual)beanContext));
            for (Bean<? extends AdviceWithRouteBuilder> beanBuilder : this.builderBeans) {
                AdviceWith.adviceWith((RouteDefinition)context.getRouteDefinition(beanBuilder.getBeanClass().getAnnotation(AdviceRoute.class).value()), (CamelContext)context, (RouteBuilder)((AdviceWithRouteBuilder)manager.getReference(beanBuilder, AdviceWithRouteBuilder.class, manager.createCreationalContext(beanBuilder))));
            }
            context.start();
        }
    }
}

