/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.telegram.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.camel.component.telegram.model.InlineKeyboardMarkup;
import org.apache.camel.component.telegram.model.InlineQueryResult;
import org.apache.camel.component.telegram.model.InputMessageContent;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class InlineQueryResultLocation
extends InlineQueryResult {
    private static final String TYPE = "location";
    private Float latitude;
    private Float longitude;
    @JsonProperty(value="live_period")
    private Integer livePeriod;
    @JsonProperty(value="thumb_url")
    private String thumbUrl;
    @JsonProperty(value="thumb_width")
    private String thumbWidth;
    @JsonProperty(value="thumb_height")
    private String thumbHeight;
    private String title;
    @JsonProperty(value="input_message_content")
    private InputMessageContent inputMessageContext;

    public InlineQueryResultLocation() {
        super(TYPE);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Float getLatitude() {
        return this.latitude;
    }

    public Float getLongitude() {
        return this.longitude;
    }

    public Integer getLivePeriod() {
        return this.livePeriod;
    }

    public String getThumbUrl() {
        return this.thumbUrl;
    }

    public String getThumbWidth() {
        return this.thumbWidth;
    }

    public String getThumbHeight() {
        return this.thumbHeight;
    }

    public String getTitle() {
        return this.title;
    }

    public InputMessageContent getInputMessageContext() {
        return this.inputMessageContext;
    }

    public void setLatitude(Float latitude) {
        this.latitude = latitude;
    }

    public void setLongitude(Float longitude) {
        this.longitude = longitude;
    }

    public void setLivePeriod(Integer livePeriod) {
        this.livePeriod = livePeriod;
    }

    public void setThumbUrl(String thumbUrl) {
        this.thumbUrl = thumbUrl;
    }

    public void setThumbWidth(String thumbWidth) {
        this.thumbWidth = thumbWidth;
    }

    public void setThumbHeight(String thumbHeight) {
        this.thumbHeight = thumbHeight;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setInputMessageContext(InputMessageContent inputMessageContext) {
        this.inputMessageContext = inputMessageContext;
    }

    public static final class Builder {
        private String id;
        private InlineKeyboardMarkup replyMarkup;
        private Float latitude;
        private Float longitude;
        private Integer livePeriod;
        private String thumbUrl;
        private String thumbWidth;
        private String thumbHeight;
        private String title;
        private InputMessageContent inputMessageContext;

        private Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder replyMarkup(InlineKeyboardMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        public Builder latitude(Float latitude) {
            this.latitude = latitude;
            return this;
        }

        public Builder longitude(Float longitude) {
            this.longitude = longitude;
            return this;
        }

        public Builder livePeriod(Integer livePeriod) {
            this.livePeriod = livePeriod;
            return this;
        }

        public Builder thumbUrl(String thumbUrl) {
            this.thumbUrl = thumbUrl;
            return this;
        }

        public Builder thumbWidth(String thumbWidth) {
            this.thumbWidth = thumbWidth;
            return this;
        }

        public Builder thumbHeight(String thumbHeight) {
            this.thumbHeight = thumbHeight;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder inputMessageContext(InputMessageContent inputMessageContext) {
            this.inputMessageContext = inputMessageContext;
            return this;
        }

        public InlineQueryResultLocation build() {
            InlineQueryResultLocation inlineQueryResultLocation = new InlineQueryResultLocation();
            inlineQueryResultLocation.setType(InlineQueryResultLocation.TYPE);
            inlineQueryResultLocation.setId(this.id);
            inlineQueryResultLocation.setReplyMarkup(this.replyMarkup);
            inlineQueryResultLocation.latitude = this.latitude;
            inlineQueryResultLocation.thumbHeight = this.thumbHeight;
            inlineQueryResultLocation.thumbWidth = this.thumbWidth;
            inlineQueryResultLocation.inputMessageContext = this.inputMessageContext;
            inlineQueryResultLocation.title = this.title;
            inlineQueryResultLocation.livePeriod = this.livePeriod;
            inlineQueryResultLocation.longitude = this.longitude;
            inlineQueryResultLocation.thumbUrl = this.thumbUrl;
            return inlineQueryResultLocation;
        }
    }
}

