/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.telegram.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.camel.component.telegram.model.InlineKeyboardMarkup;
import org.apache.camel.component.telegram.model.InlineQueryResult;
import org.apache.camel.component.telegram.model.InputMessageContent;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class InlineQueryResultCachedGif
extends InlineQueryResult {
    private static final String TYPE = "gif";
    @JsonProperty(value="gif_file_id")
    private String gifFileId;
    private String title;
    private String caption;
    @JsonProperty(value="parse_mode")
    private String parseMode;
    @JsonProperty(value="input_message_content")
    private InputMessageContent inputMessageContext;

    public InlineQueryResultCachedGif() {
        super(TYPE);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getGifFileId() {
        return this.gifFileId;
    }

    public String getTitle() {
        return this.title;
    }

    public String getCaption() {
        return this.caption;
    }

    public String getParseMode() {
        return this.parseMode;
    }

    public InputMessageContent getInputMessageContext() {
        return this.inputMessageContext;
    }

    public void setGifFileId(String gifFileId) {
        this.gifFileId = gifFileId;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public void setParseMode(String parseMode) {
        this.parseMode = parseMode;
    }

    public void setInputMessageContext(InputMessageContent inputMessageContext) {
        this.inputMessageContext = inputMessageContext;
    }

    public static final class Builder {
        private String id;
        private InlineKeyboardMarkup replyMarkup;
        private String gifFileId;
        private String title;
        private String caption;
        private String parseMode;
        private InputMessageContent inputMessageContext;

        private Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder replyMarkup(InlineKeyboardMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        public Builder gifFileId(String gifFileId) {
            this.gifFileId = gifFileId;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder caption(String caption) {
            this.caption = caption;
            return this;
        }

        public Builder parseMode(String parseMode) {
            this.parseMode = parseMode;
            return this;
        }

        public Builder inputMessageContext(InputMessageContent inputMessageContext) {
            this.inputMessageContext = inputMessageContext;
            return this;
        }

        public InlineQueryResultCachedGif build() {
            InlineQueryResultCachedGif inlineQueryResultGif = new InlineQueryResultCachedGif();
            inlineQueryResultGif.setType(InlineQueryResultCachedGif.TYPE);
            inlineQueryResultGif.setId(this.id);
            inlineQueryResultGif.setReplyMarkup(this.replyMarkup);
            inlineQueryResultGif.gifFileId = this.gifFileId;
            inlineQueryResultGif.caption = this.caption;
            inlineQueryResultGif.parseMode = this.parseMode;
            inlineQueryResultGif.title = this.title;
            inlineQueryResultGif.inputMessageContext = this.inputMessageContext;
            return inlineQueryResultGif;
        }
    }
}

