/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.telegram.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.telegram.TelegramException;
import org.apache.camel.component.telegram.TelegramService;
import org.apache.camel.component.telegram.model.EditMessageCaptionMessage;
import org.apache.camel.component.telegram.model.EditMessageDelete;
import org.apache.camel.component.telegram.model.EditMessageLiveLocationMessage;
import org.apache.camel.component.telegram.model.EditMessageMediaMessage;
import org.apache.camel.component.telegram.model.EditMessageReplyMarkupMessage;
import org.apache.camel.component.telegram.model.EditMessageTextMessage;
import org.apache.camel.component.telegram.model.MessageResult;
import org.apache.camel.component.telegram.model.MessageResultGameScores;
import org.apache.camel.component.telegram.model.OutgoingAnswerInlineQuery;
import org.apache.camel.component.telegram.model.OutgoingAudioMessage;
import org.apache.camel.component.telegram.model.OutgoingCallbackQueryMessage;
import org.apache.camel.component.telegram.model.OutgoingDocumentMessage;
import org.apache.camel.component.telegram.model.OutgoingGameMessage;
import org.apache.camel.component.telegram.model.OutgoingGetGameHighScoresMessage;
import org.apache.camel.component.telegram.model.OutgoingMessage;
import org.apache.camel.component.telegram.model.OutgoingPhotoMessage;
import org.apache.camel.component.telegram.model.OutgoingSetGameScoreMessage;
import org.apache.camel.component.telegram.model.OutgoingStickerMessage;
import org.apache.camel.component.telegram.model.OutgoingTextMessage;
import org.apache.camel.component.telegram.model.OutgoingVideoMessage;
import org.apache.camel.component.telegram.model.SendLocationMessage;
import org.apache.camel.component.telegram.model.SendVenueMessage;
import org.apache.camel.component.telegram.model.StopMessageLiveLocationMessage;
import org.apache.camel.component.telegram.model.UpdateResult;
import org.apache.camel.component.telegram.model.WebhookResult;
import org.apache.camel.component.telegram.service.OutgoingMessageHandler;
import org.apache.camel.component.telegram.service.TelegramBodyPublisher;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelegramServiceRestBotAPIAdapter
implements TelegramService {
    private static final Logger LOG = LoggerFactory.getLogger(TelegramServiceRestBotAPIAdapter.class);
    private final Map<Class<?>, OutgoingMessageHandler<?>> handlers;
    private final HttpClient client;
    @Deprecated
    private final ObjectMapper mapper;
    private final String baseUri;

    public TelegramServiceRestBotAPIAdapter(HttpClient client, String telegramBaseUri, String authorizationToken, int bufferSize) {
        this.client = client;
        this.baseUri = telegramBaseUri + "/bot" + authorizationToken;
        this.mapper = new ObjectMapper();
        HashMap m = new HashMap();
        m.put(OutgoingTextMessage.class, new OutgoingPlainMessageHandler(client, this.mapper, this.baseUri + "/sendMessage", bufferSize));
        m.put(OutgoingPhotoMessage.class, new OutgoingPhotoMessageHandler(client, this.mapper, this.baseUri, bufferSize));
        m.put(OutgoingAudioMessage.class, new OutgoingAudioMessageHandler(client, this.mapper, this.baseUri, bufferSize));
        m.put(OutgoingVideoMessage.class, new OutgoingVideoMessageHandler(client, this.mapper, this.baseUri, bufferSize));
        m.put(OutgoingDocumentMessage.class, new OutgoingDocumentMessageHandler(client, this.mapper, this.baseUri, bufferSize));
        m.put(OutgoingStickerMessage.class, new OutgoingStickerMessageHandler(client, this.mapper, this.baseUri, bufferSize));
        m.put(OutgoingGameMessage.class, new OutgoingPlainMessageHandler(client, this.mapper, this.baseUri + "/sendGame", bufferSize));
        m.put(SendLocationMessage.class, new OutgoingPlainMessageHandler(client, this.mapper, this.baseUri + "/sendLocation", bufferSize));
        m.put(EditMessageLiveLocationMessage.class, new OutgoingPlainMessageHandler(client, this.mapper, this.baseUri + "/editMessageLiveLocation", bufferSize));
        m.put(StopMessageLiveLocationMessage.class, new OutgoingPlainMessageHandler(client, this.mapper, this.baseUri + "/stopMessageLiveLocation", bufferSize));
        m.put(SendVenueMessage.class, new OutgoingPlainMessageHandler(client, this.mapper, this.baseUri + "/sendVenue", bufferSize));
        m.put(EditMessageTextMessage.class, new OutgoingPlainMessageHandler(client, this.mapper, this.baseUri + "/editMessageText", bufferSize));
        m.put(EditMessageCaptionMessage.class, new OutgoingPlainMessageHandler(client, this.mapper, this.baseUri + "/editMessageCaption", bufferSize));
        m.put(EditMessageMediaMessage.class, new OutgoingPlainMessageHandler(client, this.mapper, this.baseUri + "/editMessageMedia", bufferSize));
        m.put(EditMessageDelete.class, new OutgoingPlainMessageHandler(client, this.mapper, this.baseUri + "/deleteMessage", bufferSize));
        m.put(EditMessageReplyMarkupMessage.class, new OutgoingPlainMessageHandler(client, this.mapper, this.baseUri + "/editMessageReplyMarkup", bufferSize));
        m.put(OutgoingCallbackQueryMessage.class, new OutgoingPlainMessageHandler(client, this.mapper, this.baseUri + "/answerCallbackQuery", bufferSize));
        m.put(OutgoingSetGameScoreMessage.class, new OutgoingPlainMessageHandler(client, this.mapper, this.baseUri + "/setGameScore", bufferSize));
        m.put(OutgoingGetGameHighScoresMessage.class, new OutgoingPlainMessageHandler(client, this.mapper, this.baseUri + "/getGameHighScores", MessageResultGameScores.class, bufferSize));
        m.put(OutgoingAnswerInlineQuery.class, new OutgoingPlainMessageHandler(client, this.mapper, this.baseUri + "/answerInlineQuery", bufferSize));
        this.handlers = m;
    }

    @Override
    public UpdateResult getUpdates(Long offset, Integer limit, Integer timeoutSeconds) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (offset != null) {
            parameters.put("offset", String.valueOf(offset));
        }
        if (limit != null) {
            parameters.put("limit", String.valueOf(limit));
        }
        if (timeoutSeconds != null) {
            parameters.put("timeout", String.valueOf(timeoutSeconds));
        }
        try {
            String uri = URISupport.appendParametersToURI((String)(this.baseUri + "/getUpdates"), parameters);
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(uri)).GET().build();
            return this.sendSyncRequest(request, UpdateResult.class);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    <T> T sendSyncRequest(HttpRequest request, Class<T> resultType) {
        try {
            HttpResponse<String> response = this.client.send(request, HttpResponse.BodyHandlers.ofString());
            int code = response.statusCode();
            if (code >= 200 && code < 300) {
                String responseBody = response.body();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Received body for {} {}: {}", new Object[]{request.method(), request.uri(), responseBody});
                }
                return (T)this.mapper.readValue(responseBody, resultType);
            }
            throw new TelegramException("Could not " + request.method() + " " + request.uri() + ": " + response.statusCode() + " " + response.body(), response.statusCode(), response.body());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeCamelException("Could not parse the response from " + request.method() + " " + request.uri(), (Throwable)e);
        }
        catch (IOException e) {
            throw new RuntimeCamelException("Could not request " + request.method() + " " + request.uri(), (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    @Override
    public boolean setWebhook(String url) {
        String uri = this.baseUri + "/setWebhook?url=" + url;
        HttpRequest.Builder request = HttpRequest.newBuilder().uri(URI.create(uri)).GET();
        WebhookResult res = this.sendSyncRequest(request.build(), WebhookResult.class);
        return res.isOk() && res.isResult();
    }

    @Override
    public boolean removeWebhook() {
        String uri = this.baseUri + "/deleteWebhook";
        HttpRequest.Builder request = HttpRequest.newBuilder().uri(URI.create(uri)).GET();
        WebhookResult res = this.sendSyncRequest(request.build(), WebhookResult.class);
        return res.isOk() && res.isResult();
    }

    @Override
    public void sendMessage(Exchange exchange, AsyncCallback callback, OutgoingMessage message) {
        OutgoingMessageHandler<?> handler = this.handlers.get(message.getClass());
        if (handler == null) {
            throw new IllegalArgumentException("Unsupported message type " + message.getClass().getName());
        }
        handler.sendMessage(exchange, callback, message);
    }

    static class OutgoingPlainMessageHandler
    extends OutgoingMessageHandler<OutgoingMessage> {
        public OutgoingPlainMessageHandler(HttpClient client, ObjectMapper mapper, String uri, Class<? extends MessageResult> returnType, int bufferSize) {
            super(client, mapper, uri, "application/json", returnType, bufferSize);
        }

        public OutgoingPlainMessageHandler(HttpClient client, ObjectMapper mapper, String uri, int bufferSize) {
            this(client, mapper, uri, MessageResult.class, bufferSize);
        }

        @Override
        protected void addBody(OutgoingMessage message) {
            try {
                String body = this.mapper.writeValueAsString((Object)message);
                this.bodyPublisher.addBodyPart(new TelegramBodyPublisher.SingleBodyPart(body));
            }
            catch (JsonProcessingException e) {
                throw new RuntimeCamelException("Could not serialize " + message);
            }
        }
    }

    static class OutgoingPhotoMessageHandler
    extends OutgoingMessageHandler<OutgoingPhotoMessage> {
        public OutgoingPhotoMessageHandler(HttpClient client, ObjectMapper mapper, String baseUri, int bufferSize) {
            super(client, mapper, baseUri + "/sendPhoto", null, MessageResult.class, bufferSize);
        }

        @Override
        protected void addBody(OutgoingPhotoMessage message) {
            this.fillCommonMediaParts(message);
            this.buildMediaPart("photo", message.getFilenameWithExtension(), message.getPhoto());
            this.buildTextPart("caption", message.getCaption());
            this.buildTextPart("reply_markup", message.replyMarkupJson());
        }
    }

    static class OutgoingAudioMessageHandler
    extends OutgoingMessageHandler<OutgoingAudioMessage> {
        public OutgoingAudioMessageHandler(HttpClient client, ObjectMapper mapper, String baseUri, int bufferSize) {
            super(client, mapper, baseUri + "/sendAudio", null, MessageResult.class, bufferSize);
        }

        @Override
        protected void addBody(OutgoingAudioMessage message) {
            this.fillCommonMediaParts(message);
            this.buildMediaPart("audio", message.getFilenameWithExtension(), message.getAudio());
            this.buildTextPart("title", message.getTitle());
            this.buildTextPart("duration", message.getDurationSeconds());
            this.buildTextPart("performer", message.getPerformer());
            this.buildTextPart("reply_markup", message.replyMarkupJson());
        }
    }

    static class OutgoingVideoMessageHandler
    extends OutgoingMessageHandler<OutgoingVideoMessage> {
        public OutgoingVideoMessageHandler(HttpClient client, ObjectMapper mapper, String baseUri, int bufferSize) {
            super(client, mapper, baseUri + "/sendVideo", null, MessageResult.class, bufferSize);
        }

        @Override
        protected void addBody(OutgoingVideoMessage message) {
            this.fillCommonMediaParts(message);
            this.buildMediaPart("video", message.getFilenameWithExtension(), message.getVideo());
            this.buildTextPart("caption", message.getCaption());
            this.buildTextPart("duration", message.getDurationSeconds());
            this.buildTextPart("width", message.getWidth());
            this.buildTextPart("height", message.getHeight());
            this.buildTextPart("reply_markup", message.replyMarkupJson());
        }
    }

    static class OutgoingDocumentMessageHandler
    extends OutgoingMessageHandler<OutgoingDocumentMessage> {
        public OutgoingDocumentMessageHandler(HttpClient client, ObjectMapper mapper, String baseUri, int bufferSize) {
            super(client, mapper, baseUri + "/sendDocument", null, MessageResult.class, bufferSize);
        }

        @Override
        protected void addBody(OutgoingDocumentMessage message) {
            this.fillCommonMediaParts(message);
            this.buildMediaPart("document", message.getFilenameWithExtension(), message.getDocument());
            this.buildTextPart("caption", message.getCaption());
            this.buildTextPart("reply_markup", message.replyMarkupJson());
        }
    }

    static class OutgoingStickerMessageHandler
    extends OutgoingMessageHandler<OutgoingStickerMessage> {
        public OutgoingStickerMessageHandler(HttpClient client, ObjectMapper mapper, String baseUri, int bufferSize) {
            super(client, mapper, baseUri + "/sendSticker", null, MessageResult.class, bufferSize);
        }

        @Override
        protected void addBody(OutgoingStickerMessage message) {
            this.fillCommonMediaParts(message);
            if (message.getSticker() != null) {
                this.buildTextPart("sticker", message.getSticker());
            } else {
                this.buildMediaPart("sticker", message.getFilenameWithExtension(), message.getStickerImage());
            }
        }
    }
}

