/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.generator.swagger;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.generator.swagger.CodeEmitter;
import org.apache.camel.model.rest.RestsDefinition;

class RestDefinitionEmitter
implements CodeEmitter<RestsDefinition> {
    private final RestsDefinition definition = new RestsDefinition();
    private Object variable = this.definition;

    RestDefinitionEmitter(CamelContext context) {
    }

    @Override
    public CodeEmitter<RestsDefinition> emit(String method, Object ... args) {
        try {
            Class<?> type = this.variable.getClass();
            Object[] arguments = this.argumentsFor(args);
            Method declaredMethod = type.getMethod(method, this.parameterTypesOf(arguments));
            this.variable = declaredMethod.invoke(this.variable, arguments);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
        return this;
    }

    @Override
    public RestsDefinition result() {
        return this.definition;
    }

    Object[] argumentsFor(Object[] args) {
        ArrayList<Object> arguments = new ArrayList<Object>(args.length);
        for (Object arg : args) {
            if (arg instanceof String[]) {
                arguments.add(Arrays.stream((String[])arg).collect(Collectors.joining(",")));
                continue;
            }
            arguments.add(arg);
        }
        return arguments.toArray(new Object[arguments.size()]);
    }

    Class<?>[] parameterTypesOf(Object[] args) {
        Class[] parameterTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            parameterTypes[i] = args[i].getClass();
        }
        return parameterTypes;
    }

    Class<?>[] typesOf(Object[] args) {
        Class[] types = new Class[args.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = args[i].getClass();
        }
        return types;
    }
}

